/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.IndexNode;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Index;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class IndexNodeProvider
extends NodeProvider {
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private final MetadataElementHandle handle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    private static final Comparator<Node> indexComparator = new Comparator<Node>(){

        @Override
        public int compare(Node model1, Node model2) {
            return model1.getDisplayName().compareTo(model2.getDisplayName());
        }
    };

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private IndexNodeProvider(Lookup lookup) {
        super(lookup, indexComparator);
    }

    @Override
    protected synchronized void initialize() {
        final ArrayList<Node> newList = new ArrayList<Node>();
        boolean connected = this.connection.isConnected();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        if (connected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){
                    final /* synthetic */ IndexNodeProvider this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run(Metadata metaData) {
                        Table table = (Table)this.this$0.handle.resolve(metaData);
                        if (table != null) {
                            Collection indexes = table.getIndexes();
                            for (Index index : indexes) {
                                MetadataElementHandle h = MetadataElementHandle.create((MetadataElement)index);
                                Collection matches = this.this$0.getNodes(h);
                                if (matches.size() > 0) {
                                    newList.addAll(matches);
                                    continue;
                                }
                                NodeDataLookup lookup = new NodeDataLookup();
                                lookup.add(this.this$0.connection);
                                lookup.add(h);
                                newList.add(IndexNode.create(lookup, this.this$0));
                            }
                        }
                    }
                });
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, e, true);
            }
        }
        this.setNodes(newList);
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            @Override
            public IndexNodeProvider createInstance(Lookup lookup) {
                IndexNodeProvider provider = new IndexNodeProvider(lookup);
                return provider;
            }
        };

        private FactoryHolder() {
        }
    }
}

