/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.spi.newproject;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Parent;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class CreateProjectBuilder {
    private static final String SKELETON = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n    <modelVersion>4.0.0</modelVersion>\n</project>";
    private final File projectDirectory;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private String packageName;
    private String packaging = "jar";
    private boolean updateParent = true;
    private MavenProject parentProject;
    private PomOperationsHandle operations;
    private AdditionalChangeHandle moreWork;
    private ProgressHandle progressHandle;

    public CreateProjectBuilder(File projectDir, String groupId, String artifactId, String version) {
        this.projectDirectory = projectDir;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public CreateProjectBuilder setPackaging(String packaging) {
        this.packaging = packaging;
        return this;
    }

    public CreateProjectBuilder setPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public CreateProjectBuilder setUpdateParent(boolean update) {
        this.updateParent = update;
        return this;
    }

    public CreateProjectBuilder setParentProject(MavenProject parent) {
        this.parentProject = parent;
        return this;
    }

    public CreateProjectBuilder setAdditionalOperations(PomOperationsHandle opers) {
        this.operations = opers;
        return this;
    }

    public CreateProjectBuilder setAdditionalNonPomWork(AdditionalChangeHandle action) {
        this.moreWork = action;
        return this;
    }

    public CreateProjectBuilder setProgressHandle(ProgressHandle handle) {
        this.progressHandle = handle;
        return this;
    }

    public void create() {
        Runnable action;
        NbMavenProject nbMavenParent;
        Project p;
        this.projectDirectory.mkdirs();
        ArrayList<ModelOperation<POMModel>> pomOpers = new ArrayList<ModelOperation<POMModel>>();
        MavenProject parent = this.parentProject;
        if (parent == null && (p = FileOwnerQuery.getOwner((URI)org.openide.util.Utilities.toURI((File)this.projectDirectory))) != null && (nbMavenParent = (NbMavenProject)p.getLookup().lookup(NbMavenProject.class)) != null && "pom".equals(nbMavenParent.getMavenProject().getPackaging())) {
            parent = nbMavenParent.getMavenProject();
        }
        if (parent != null && NbMavenProject.isErrorPlaceholder(parent)) {
            parent = null;
        }
        Context context = new Context(parent, this.groupId, this.artifactId, this.version, this.packaging, this.projectDirectory, this.packageName);
        pomOpers.add(new BasicPropertiesOperation(context));
        if (this.operations != null) {
            pomOpers.addAll(this.operations.createPomOperations(context));
        }
        if (this.progressHandle != null) {
            this.progressHandle.progress("Writing pom.xml");
        }
        ModelSource model = Utilities.createModelSourceForMissingFile((File)new File(this.projectDirectory, "pom.xml"), (boolean)true, (String)SKELETON, (String)"text/x-maven-pom+xml");
        Utilities.performPOMModelOperations((ModelSource)model, pomOpers);
        if (this.updateParent && parent != null) {
            if (this.progressHandle != null) {
                this.progressHandle.progress("Updating parent pom.xml");
            }
            FileObject pom = FileUtil.toFileObject((File)parent.getFile());
            assert (pom != null) : "parent file:" + String.valueOf(parent.getFile()) + " for project " + parent.getId() + "  wizard directory: " + String.valueOf(this.projectDirectory);
            if (pom != null) {
                ModelSource pmodel = Utilities.createModelSource((FileObject)pom);
                Utilities.performPOMModelOperations((ModelSource)pmodel, Collections.singletonList(new AddModuleToParentOperation(pom.getParent(), this.projectDirectory)));
            }
        }
        if (this.moreWork != null && (action = this.moreWork.createAdditionalChange(context)) != null) {
            action.run();
        }
    }

    public static interface PomOperationsHandle {
        @NonNull
        public List<ModelOperation<POMModel>> createPomOperations(@NonNull Context var1);
    }

    public static interface AdditionalChangeHandle {
        public Runnable createAdditionalChange(@NonNull Context var1);
    }

    public static final class Context {
        private final String packaging;
        private final String version;
        private final String artifactId;
        private final String groupId;
        private final MavenProject parent;
        private final File projectDirectory;
        private final String packageName;

        private Context(MavenProject parent, String groupId, String artifactId, String version, String packaging, File projectDirectory, String packageName) {
            this.parent = parent;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.packaging = packaging;
            this.projectDirectory = projectDirectory;
            this.packageName = packageName;
        }

        @NonNull
        public String getPackaging() {
            return this.packaging;
        }

        @NonNull
        public String getVersion() {
            return this.version;
        }

        @NonNull
        public String getArtifactId() {
            return this.artifactId;
        }

        @NonNull
        public String getGroupId() {
            return this.groupId;
        }

        @CheckForNull
        public MavenProject getParent() {
            return this.parent;
        }

        @NonNull
        public File getProjectDirectory() {
            return this.projectDirectory;
        }

        @CheckForNull
        public String getPackageName() {
            return this.packageName;
        }
    }

    private class BasicPropertiesOperation
    implements ModelOperation<POMModel> {
        private final Context context;

        public BasicPropertiesOperation(Context context) {
            this.context = context;
        }

        public void performOperation(POMModel model) {
            org.netbeans.modules.maven.model.pom.Project root = model.getProject();
            if (root != null) {
                Properties parentprops;
                MavenProject parent = this.context.getParent();
                if (parent != null) {
                    Parent parentpom = model.getFactory().createParent();
                    parentpom.setGroupId(parent.getGroupId());
                    parentpom.setArtifactId(parent.getArtifactId());
                    parentpom.setVersion(parent.getVersion());
                    File pfile = FileUtil.normalizeFile((File)parent.getFile());
                    String rel = FileUtilities.relativizeFile(this.context.getProjectDirectory(), pfile);
                    if (rel != null) {
                        if (!"..".equals(rel) && !"../pom.xml".equals(rel)) {
                            parentpom.setRelativePath(rel);
                        }
                    } else {
                        parentpom.setRelativePath("");
                    }
                    root.setPomParent(parentpom);
                }
                if (parent == null || !this.context.getGroupId().equals(parent.getGroupId())) {
                    root.setGroupId(this.context.getGroupId());
                }
                root.setArtifactId(this.context.getArtifactId());
                if (parent == null || !this.context.getVersion().equals(parent.getVersion())) {
                    root.setVersion(this.context.getVersion());
                }
                root.setPackaging(CreateProjectBuilder.this.packaging);
                boolean setEncoding = true;
                if (parent != null && (parentprops = parent.getProperties()) != null && parentprops.containsKey("project.build.sourceEncoding")) {
                    setEncoding = false;
                }
                if (setEncoding) {
                    org.netbeans.modules.maven.model.pom.Properties props = root.getProperties();
                    if (props == null) {
                        props = model.getFactory().createProperties();
                        root.setProperties(props);
                    }
                    props.setProperty("project.build.sourceEncoding", "UTF-8");
                }
            }
        }
    }

    private static class AddModuleToParentOperation
    implements ModelOperation<POMModel> {
        private final String relPath;

        public AddModuleToParentOperation(FileObject projectDirectory, File projFile) {
            FileObject dir = FileUtil.toFileObject((File)projFile);
            this.relPath = FileUtil.getRelativePath((FileObject)projectDirectory, (FileObject)dir);
        }

        public void performOperation(POMModel model) {
            List modules;
            if (!(this.relPath == null || model.getProject() == null || (modules = model.getProject().getModules()) != null && modules.contains(this.relPath))) {
                model.getProject().addModule(this.relPath);
            }
        }
    }
}

