/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteInternetGatewayRequest
extends BmcRequest<Void> {
    private String igId;
    private String ifMatch;

    public String getIgId() {
        return this.igId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().igId(this.igId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",igId=").append(String.valueOf(this.igId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteInternetGatewayRequest)) {
            return false;
        }
        DeleteInternetGatewayRequest other = (DeleteInternetGatewayRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.igId, other.igId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.igId == null ? 43 : this.igId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteInternetGatewayRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String igId = null;
        private String ifMatch = null;

        public Builder igId(String igId) {
            this.igId = igId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteInternetGatewayRequest o) {
            this.igId(o.getIgId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteInternetGatewayRequest build() {
            DeleteInternetGatewayRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteInternetGatewayRequest buildWithoutInvocationCallback() {
            DeleteInternetGatewayRequest request = new DeleteInternetGatewayRequest();
            request.igId = this.igId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

