/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteDedicatedVmHostRequest
extends BmcRequest<Void> {
    private String dedicatedVmHostId;
    private String opcRequestId;

    public String getDedicatedVmHostId() {
        return this.dedicatedVmHostId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().dedicatedVmHostId(this.dedicatedVmHostId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dedicatedVmHostId=").append(String.valueOf(this.dedicatedVmHostId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteDedicatedVmHostRequest)) {
            return false;
        }
        DeleteDedicatedVmHostRequest other = (DeleteDedicatedVmHostRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dedicatedVmHostId, other.dedicatedVmHostId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dedicatedVmHostId == null ? 43 : this.dedicatedVmHostId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteDedicatedVmHostRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dedicatedVmHostId = null;
        private String opcRequestId = null;

        public Builder dedicatedVmHostId(String dedicatedVmHostId) {
            this.dedicatedVmHostId = dedicatedVmHostId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDedicatedVmHostRequest o) {
            this.dedicatedVmHostId(o.getDedicatedVmHostId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDedicatedVmHostRequest build() {
            DeleteDedicatedVmHostRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteDedicatedVmHostRequest buildWithoutInvocationCallback() {
            DeleteDedicatedVmHostRequest request = new DeleteDedicatedVmHostRequest();
            request.dedicatedVmHostId = this.dedicatedVmHostId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

