/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.dashboard;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.ide.dashboard.Bundle;
import org.netbeans.spi.dashboard.DashboardDisplayer;
import org.netbeans.spi.dashboard.DashboardWidget;
import org.netbeans.spi.dashboard.WidgetElement;
import org.openide.LifecycleManager;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;

public class AppearanceWidget
implements DashboardWidget {
    private static final String FLAT_LIGHT_LAF = "com.formdev.flatlaf.FlatLightLaf";
    private static final String FLAT_LIGHT_PROFILE = "FlatLaf Light";
    private static final String FLAT_DARK_LAF = "com.formdev.flatlaf.FlatDarkLaf";
    private static final String FLAT_DARK_PROFILE = "FlatLaf Dark";
    private final boolean isDefaultLaf;

    public AppearanceWidget() {
        String laf = NbPreferences.root().node("laf").get("laf", "");
        this.isDefaultLaf = laf.isEmpty() || FLAT_LIGHT_LAF.equals(laf);
    }

    public String title(DashboardDisplayer.Panel panel) {
        return Bundle.TITLE_Appearance();
    }

    public List<WidgetElement> elements(DashboardDisplayer.Panel panel) {
        return List.of(WidgetElement.text((String)Bundle.TXT_Appearance()), WidgetElement.action((Action)new SwitchLafAction(this.isDefaultLaf)), WidgetElement.aside((String)Bundle.TXT_RequiresRestart()), WidgetElement.separator(), WidgetElement.text((String)Bundle.TXT_AdvancedLAF()), WidgetElement.actionLink((Action)new ShowFlatLafOptions()));
    }

    private static class SwitchLafAction
    extends AbstractAction {
        private static Notification restartNotification;
        private final boolean dark;

        private SwitchLafAction(boolean dark) {
            super(dark ? Bundle.LBL_DarkLaf() : Bundle.LBL_DefaultLaf());
            this.dark = dark;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String laf = this.dark ? AppearanceWidget.FLAT_DARK_LAF : AppearanceWidget.FLAT_LIGHT_LAF;
            String profile = this.dark ? AppearanceWidget.FLAT_DARK_PROFILE : AppearanceWidget.FLAT_LIGHT_PROFILE;
            NbPreferences.root().node("laf").put("laf", laf);
            FileObject editorConfig = FileUtil.getConfigFile((String)"Editors");
            if (editorConfig != null) {
                try {
                    editorConfig.setAttribute("currentFontColorProfile", (Object)profile);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            this.askForRestart();
        }

        private void askForRestart() {
            if (restartNotification != null) {
                restartNotification.clear();
            }
            restartNotification = NotificationDisplayer.getDefault().notify(Bundle.TITLE_RestartIDE(), (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/core/windows/resources/restart.png", (boolean)true), Bundle.TXT_RestartIDE(), e -> {
                if (restartNotification != null) {
                    restartNotification.clear();
                    restartNotification = null;
                }
                LifecycleManager.getDefault().markForRestart();
                LifecycleManager.getDefault().exit();
            });
        }
    }

    private static class ShowFlatLafOptions
    extends AbstractAction {
        private ShowFlatLafOptions() {
            super(Bundle.LBL_AdvancedLAFPanel());
            this.putValue("ShortDescription", Bundle.STATUS_AdvancedLAFPanel());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OptionsDisplayer.getDefault().open("Appearance/org-netbeans-swing-laf-flatlaf-FlatLafOptionsPanelController");
        }
    }
}

