/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.amazon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.cloud.amazon.AmazonInstance;
import org.netbeans.modules.cloud.amazon.AmazonInstanceManager;
import org.netbeans.modules.cloud.amazon.AmazonServerInstanceImplementation;
import org.netbeans.spi.server.ServerInstanceFactory;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.util.ChangeSupport;

public class AmazonServerInstanceProvider
implements ServerInstanceProvider,
ChangeListener {
    private ChangeSupport listeners = new ChangeSupport((Object)this);
    private List<ServerInstance> instances = Collections.emptyList();
    private static AmazonServerInstanceProvider instance;

    private AmazonServerInstanceProvider() {
        AmazonInstanceManager.getDefault().addChangeListener(this);
        this.refreshServers();
    }

    public static synchronized AmazonServerInstanceProvider getProvider() {
        if (instance == null) {
            instance = new AmazonServerInstanceProvider();
        }
        return instance;
    }

    public List<ServerInstance> getInstances() {
        return this.instances;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.removeChangeListener(listener);
    }

    private void refreshServers() {
        ArrayList<ServerInstance> servers = new ArrayList<ServerInstance>();
        for (AmazonInstance ai : AmazonInstanceManager.getDefault().getInstances()) {
            ServerInstance si = ServerInstanceFactory.createServerInstance((ServerInstanceImplementation)new AmazonServerInstanceImplementation(ai));
            ai.setServerInstance(si);
            servers.add(si);
        }
        this.instances = servers;
        this.listeners.fireChange();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refreshServers();
    }
}

