/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.css;

import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.css.editor.module.spi.Browser;
import org.netbeans.modules.css.editor.module.spi.CssEditorModule;
import org.netbeans.modules.css.editor.module.spi.EditorFeatureContext;
import org.netbeans.modules.css.editor.module.spi.Utilities;
import org.netbeans.modules.css.lib.api.CssModule;
import org.netbeans.modules.css.lib.api.properties.PropertyCategory;
import org.netbeans.modules.css.lib.api.properties.PropertyDefinition;
import org.netbeans.modules.javafx2.editor.css.Bundle;
import org.netbeans.modules.javafx2.project.api.JavaFXProjectUtils;
import org.openide.filesystems.FileObject;

public class JavaFXCSSModule
extends CssEditorModule
implements CssModule {
    static ElementKind JFX_CSS_ELEMENT_KIND = ElementKind.GLOBAL;
    private static final String PROPERTIES_DEFINITION_PATH = "org/netbeans/modules/javafx2/editor/css/javafx2";
    private static Map<String, PropertyDefinition> propertyDescriptors;
    private static SoftReference<Map<String, Boolean>> fileTypeCache;
    private static final String PSEUDO_CLASSES_PROPERTY = "@pseudo-classes";
    private static Collection<String> pseudoClasses;
    private static Browser FX_BROWSER;

    public Collection<String> getPseudoClasses(EditorFeatureContext context) {
        if (pseudoClasses == null) {
            pseudoClasses = new ArrayList<String>();
            PropertyDefinition prop = this.getJavaFXProperties().get(PSEUDO_CLASSES_PROPERTY);
            if (prop != null) {
                String grammar = prop.getGrammar();
                StringTokenizer tokenizer = new StringTokenizer(grammar, "| ");
                while (tokenizer.hasMoreTokens()) {
                    pseudoClasses.add(tokenizer.nextToken());
                }
            }
        }
        return pseudoClasses;
    }

    public Collection<Browser> getExtraBrowsers(FileObject file) {
        return this.isJavaFXContext(file) ? Collections.singleton(FX_BROWSER) : null;
    }

    public Collection<String> getPropertyNames(FileObject file) {
        return this.isJavaFXContext(file) ? this.getJavaFXProperties().keySet() : Collections.emptyList();
    }

    public PropertyDefinition getPropertyDefinition(String propertyName) {
        return this.getJavaFXProperties().get(propertyName);
    }

    private synchronized Map<String, PropertyDefinition> getJavaFXProperties() {
        if (propertyDescriptors == null) {
            propertyDescriptors = Utilities.parsePropertyDefinitionFile((String)PROPERTIES_DEFINITION_PATH, (CssModule)this);
        }
        return propertyDescriptors;
    }

    private boolean isJavaFXContext(FileObject file) {
        if (file != null) {
            Map<Object, Object> m;
            if (fileTypeCache == null) {
                m = new HashMap();
                fileTypeCache = new SoftReference(m);
            } else {
                m = fileTypeCache.get();
            }
            if (m != null) {
                Boolean b = (Boolean)m.get(file.getPath());
                if (b != null) {
                    return b;
                }
                Project p = FileOwnerQuery.getOwner((FileObject)file);
                if (p != null) {
                    boolean isFX = JavaFXProjectUtils.isJavaFxEnabled((Project)p) || JavaFXProjectUtils.isMavenFxProject((Project)p);
                    m.put(file.getPath(), isFX);
                    return isFX;
                }
            }
        }
        return false;
    }

    public String getName() {
        return "javafx2_css";
    }

    public String getDisplayName() {
        return Bundle.JavaFXCSSModule_displayName();
    }

    public String getSpecificationURL() {
        return "http://docs.oracle.com/javafx/2/api/javafx/scene/doc-files/cssref.html";
    }

    static {
        FX_BROWSER = new FxBrowser();
    }

    private static class FxBrowser
    extends Browser {
        private static final String VENDOR = "Oracle";
        private static final String NAME = "JavaFX";
        private static final String RENDERING_ENGINE = "javafx";
        private static final String PREFIX = "fx";
        private static final String ICONS_LOCATION = "/org/netbeans/modules/javafx2/editor/resources/";
        private static final String iconBase = "javafxicon";
        private URL active;
        private URL inactive;

        private FxBrowser() {
        }

        public PropertyCategory getPropertyCategory() {
            return PropertyCategory.UNKNOWN;
        }

        public String getVendor() {
            return VENDOR;
        }

        public String getName() {
            return NAME;
        }

        public String getDescription() {
            return this.getVendor() + ' ' + this.getName();
        }

        public String getRenderingEngineId() {
            return RENDERING_ENGINE;
        }

        public String getVendorSpecificPropertyId() {
            return PREFIX;
        }

        public synchronized URL getActiveIcon() {
            if (this.active == null) {
                this.active = FxBrowser.class.getResource("/org/netbeans/modules/javafx2/editor/resources/javafxicon.png");
            }
            return this.active;
        }

        public synchronized URL getInactiveIcon() {
            if (this.inactive == null) {
                this.inactive = FxBrowser.class.getResource("/org/netbeans/modules/javafx2/editor/resources/javafxicon-disabled.png");
            }
            return this.inactive;
        }
    }
}

