/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.focus;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.awt.GraphicsEnvironment;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.io.InputOutput;
import org.netbeans.api.io.OutputWriter;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class AWTGrabHandler {
    private static final Logger logger = Logger.getLogger(AWTGrabHandler.class.getName());
    private JPDADebuggerImpl debugger;
    private Boolean doGrabCheck = null;

    AWTGrabHandler(JPDADebuggerImpl debugger) {
        this.debugger = debugger;
    }

    public boolean solveGrabbing(VirtualMachine vm) {
        if (vm == null) {
            return true;
        }
        if (Boolean.FALSE.equals(this.doGrabCheck)) {
            return true;
        }
        if (GraphicsEnvironment.isHeadless()) {
            this.doGrabCheck = Boolean.FALSE;
            return true;
        }
        List allThreads = VirtualMachineWrapper.allThreads0((VirtualMachine)vm);
        for (ThreadReference t : allThreads) {
            boolean success;
            if (!t.isSuspended() || (success = this.solveGrabbing(t))) continue;
            return false;
        }
        return true;
    }

    public boolean solveGrabbing(ThreadReference t) {
        String name;
        if (Boolean.FALSE.equals(this.doGrabCheck)) {
            return true;
        }
        try {
            name = ThreadReferenceWrapper.name((ThreadReference)t);
        }
        catch (InternalExceptionWrapper ex) {
            return true;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return true;
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            return true;
        }
        catch (IllegalThreadStateExceptionWrapper ex) {
            return true;
        }
        logger.fine("solveGrabbing(" + name + ")");
        TOOLKIT tkt = TOOLKIT.get(name);
        if (tkt != null) {
            if (this.doGrabCheck == null) {
                this.doGrabCheck = this.checkXServer(t, tkt);
                logger.fine("Doing the AWT grab check = " + this.doGrabCheck);
            }
            if (Boolean.TRUE.equals(this.doGrabCheck)) {
                ObjectReference grabbedWindow = tkt == TOOLKIT.AWT ? AWTGrabHandler.getGrabbedWindow(t) : null;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Thread " + t + ": some window is grabbed: " + grabbedWindow);
                }
                if (grabbedWindow != null || tkt == TOOLKIT.JAVAFX) {
                    InputOutput io;
                    boolean successUngrab = this.ungrabWindow(t, grabbedWindow, 5000, tkt);
                    logger.fine("Grabbed window was ungrabbed: " + successUngrab);
                    if (!successUngrab && (io = this.debugger.getConsoleIO().getIO()) != null) {
                        OutputWriter ow = io.getErr();
                        ow.println(NbBundle.getMessage(AWTGrabHandler.class, (String)"MSG_GrabNotReleasedDbgContinue"));
                        ow.flush();
                        io.show();
                    }
                    return successUngrab;
                }
            }
        }
        return true;
    }

    private static ObjectReference getGrabbedWindow(ThreadReference t) {
        try {
            VirtualMachine vm = MirrorWrapper.virtualMachine((Mirror)t);
            List classesByName = VirtualMachineWrapper.classesByName0((VirtualMachine)vm, (String)"sun.awt.X11.XAwtState");
            if (classesByName.isEmpty()) {
                logger.fine("No XAwtState class found.");
                return null;
            }
            ReferenceType rt = (ReferenceType)classesByName.get(0);
            Field grabWindowRefField = ReferenceTypeWrapper.fieldByName((ReferenceType)rt, (String)"grabWindowRef");
            if (grabWindowRefField == null) {
                logger.info("No grabWindowRef field");
                return null;
            }
            Value grabWindowRef = ReferenceTypeWrapper.getValue((ReferenceType)rt, (Field)grabWindowRefField);
            if (grabWindowRef == null) {
                logger.fine("grabWindowRef field is null.");
                return null;
            }
            classesByName = VirtualMachineWrapper.classesByName0((VirtualMachine)vm, (String)"java.lang.ref.Reference");
            if (classesByName.isEmpty()) {
                logger.info("No Reference class found.");
                return null;
            }
            Field referenceField = ReferenceTypeWrapper.fieldByName((ReferenceType)((ReferenceType)classesByName.get(0)), (String)"referent");
            if (referenceField == null) {
                logger.info("No referent field in Reference class");
                return null;
            }
            Value grabWindow = ObjectReferenceWrapper.getValue((ObjectReference)((ObjectReference)grabWindowRef), (Field)referenceField);
            if (grabWindow == null) {
                logger.fine("Grabbed window is null");
                return null;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Grabbed window is " + grabWindow);
            }
            return (ObjectReference)grabWindow;
        }
        catch (InternalExceptionWrapper ex) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return null;
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            return null;
        }
        catch (ClassNotPreparedExceptionWrapper ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ungrabWindow(final ThreadReference tr, final ObjectReference grabbedWindow, int timeout, final TOOLKIT tkt) {
        final boolean[] success = new boolean[]{false};
        RequestProcessor.Task task = this.debugger.getRequestProcessor().create(new Runnable(){
            final /* synthetic */ AWTGrabHandler this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                switch (tkt.ordinal()) {
                    case 0: {
                        success[0] = this.this$0.ungrabWindowAWT(tr, grabbedWindow);
                        break;
                    }
                    case 1: {
                        this.this$0.ungrabWindowFX(tr);
                        success[0] = true;
                    }
                }
            }
        });
        JPDAThreadImpl thread = this.debugger.getThread(tr);
        try {
            thread.notifyMethodInvoking();
            task.schedule(0);
            task.waitFinished((long)timeout);
        }
        catch (PropertyVetoException pvex) {
            logger.log(Level.INFO, "Method invoke vetoed", pvex);
            thread = null;
        }
        catch (InterruptedException pvex) {
        }
        finally {
            if (thread != null) {
                thread.notifyMethodInvokeDone();
            }
        }
        if (!task.isFinished()) {
            this.debugger.finish();
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(AWTGrabHandler.class, (String)"MSG_GrabNotReleasedDbgKilled"), 2);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
            return true;
        }
        return success[0];
    }

    private boolean ungrabWindowAWT(ThreadReference tr, ObjectReference grabbedWindow) {
        try {
            VirtualMachine vm = MirrorWrapper.virtualMachine((Mirror)grabbedWindow);
            List xbaseWindowClassesByName = VirtualMachineWrapper.classesByName((VirtualMachine)vm, (String)"sun.awt.X11.XBaseWindow");
            if (xbaseWindowClassesByName.isEmpty()) {
                logger.info("Unable to release X grab, no XBaseWindow class in target VM " + VirtualMachineWrapper.description((VirtualMachine)vm));
                return false;
            }
            ClassType XBaseWindowClass = (ClassType)xbaseWindowClassesByName.get(0);
            Method ungrabInput = XBaseWindowClass.concreteMethodByName("ungrabInput", "()V");
            if (ungrabInput == null) {
                logger.info("Unable to release X grab, method ungrabInput not found in target VM " + VirtualMachineWrapper.description((VirtualMachine)vm));
                return false;
            }
            XBaseWindowClass.invokeMethod(tr, ungrabInput, Collections.emptyList(), 1);
        }
        catch (VMDisconnectedExceptionWrapper vmdex) {
            return true;
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Unable to release X grab.", ex);
            return false;
        }
        return true;
    }

    private boolean ungrabWindowFX(ThreadReference tr) {
        try {
            VirtualMachine vm = MirrorWrapper.virtualMachine((Mirror)tr);
            List windowClassesByName = VirtualMachineWrapper.classesByName((VirtualMachine)vm, (String)"javafx.stage.Window");
            if (windowClassesByName.isEmpty()) {
                logger.info("Unable to release FX X grab, no javafx.stage.Window class in target VM " + VirtualMachineWrapper.description((VirtualMachine)vm));
                return true;
            }
            ClassType WindowClass = (ClassType)windowClassesByName.get(0);
            Method getWindowsMethod = WindowClass.concreteMethodByName("impl_getWindows", "()Ljava/util/Iterator;");
            if (getWindowsMethod == null) {
                logger.info("Unable to release FX X grab, no impl_getWindows() method in " + WindowClass);
                return true;
            }
            ObjectReference windowsIterator = (ObjectReference)WindowClass.invokeMethod(tr, getWindowsMethod, Collections.emptyList(), 1);
            if (windowsIterator == null) {
                return true;
            }
            InterfaceType IteratorClass = (InterfaceType)VirtualMachineWrapper.classesByName((VirtualMachine)vm, (String)Iterator.class.getName()).get(0);
            Method hasNext = IteratorClass.methodsByName("hasNext", "()Z").get(0);
            Method next = IteratorClass.methodsByName("next", "()Ljava/lang/Object;").get(0);
            while (this.hasNext(hasNext, tr, windowsIterator)) {
                ObjectReference w = this.next(next, tr, windowsIterator);
                this.ungrabWindowFX(WindowClass, w, tr);
            }
        }
        catch (VMDisconnectedExceptionWrapper vmdex) {
            return true;
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Unable to release FX X grab (if any).", ex);
            return true;
        }
        return true;
    }

    private boolean hasNext(Method hasNext, ThreadReference tr, ObjectReference iterator) throws Exception {
        Value v = iterator.invokeMethod(tr, hasNext, Collections.emptyList(), 1);
        return v instanceof BooleanValue && ((BooleanValue)v).booleanValue();
    }

    private ObjectReference next(Method next, ThreadReference tr, ObjectReference iterator) throws Exception {
        return (ObjectReference)iterator.invokeMethod(tr, next, Collections.emptyList(), 1);
    }

    private void ungrabWindowFX(ClassType WindowClass, ObjectReference w, ThreadReference tr) throws Exception {
        Field focusGrabCounterField = WindowClass.fieldByName("focusGrabCounter");
        if (focusGrabCounterField == null) {
            logger.info("Unable to release FX X grab, no focusGrabCounter field in " + w);
            return;
        }
        Value focusGrabCounterValue = w.getValue(focusGrabCounterField);
        if (!(focusGrabCounterValue instanceof IntegerValue)) {
            logger.info("Unable to release FX X grab, focusGrabCounter does not have an integer value in " + w);
            return;
        }
        int focusGrabCounter = ((IntegerValue)focusGrabCounterValue).intValue();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Focus grab counter of " + w + " is: " + focusGrabCounter);
        }
        while (focusGrabCounter-- > 0) {
            Field impl_peerField = WindowClass.fieldByName("impl_peer");
            if (impl_peerField == null) {
                logger.info("Unable to release FX X grab, no impl_peer field in " + w);
                return;
            }
            ObjectReference impl_peer = (ObjectReference)w.getValue(impl_peerField);
            if (impl_peer == null) continue;
            InterfaceType TKStageClass = (InterfaceType)w.virtualMachine().classesByName("com.sun.javafx.tk.TKStage").get(0);
            Method ungrabFocusMethod = TKStageClass.methodsByName("ungrabFocus", "()V").get(0);
            impl_peer.invokeMethod(tr, ungrabFocusMethod, Collections.emptyList(), 1);
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("FX Window " + w + " was successfully ungrabbed.");
        }
    }

    private boolean ungrabWindowFX_OLD(ThreadReference tr) {
        try {
            VirtualMachine vm = MirrorWrapper.virtualMachine((Mirror)tr);
            List windowStageClassesByName = VirtualMachineWrapper.classesByName((VirtualMachine)vm, (String)"com.sun.javafx.tk.quantum.WindowStage");
            if (windowStageClassesByName.isEmpty()) {
                logger.info("Unable to release FX X grab, no quantum WindowStage class in target VM " + VirtualMachineWrapper.description((VirtualMachine)vm));
                return false;
            }
            ClassType WindowStageClass = (ClassType)windowStageClassesByName.get(0);
            Field platformWindowsField = WindowStageClass.fieldByName("platformWindows");
            if (platformWindowsField == null) {
                logger.info("Unable to release FX X grab, no platformWindows field found in WindowStage in target VM " + VirtualMachineWrapper.description((VirtualMachine)vm));
                return false;
            }
            ObjectReference platformWindows = (ObjectReference)WindowStageClass.getValue(platformWindowsField);
            if (platformWindows == null) {
                logger.info("Unable to release FX X grab, no platformWindows field has null value in WindowStage in target VM " + VirtualMachineWrapper.description((VirtualMachine)vm));
                return false;
            }
        }
        catch (VMDisconnectedExceptionWrapper vmdex) {
            return true;
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Unable to release FX X grab (if any).", ex);
            return true;
        }
        return true;
    }

    private boolean checkXServer(ThreadReference t, TOOLKIT tkt) {
        try {
            return this.checkXServerExc(t, tkt);
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "Exception thrown from checkXServer: ", ex);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    private Boolean checkXServerExc(ThreadReference tr, TOOLKIT tkt) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 25[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isAssignable(ClassType ct1, ClassType ct2) {
        if (ct1.equals(ct2)) {
            return true;
        }
        ClassType cts = ct2.superclass();
        if (cts != null) {
            return AWTGrabHandler.isAssignable(ct1, cts);
        }
        return false;
    }

    private static enum TOOLKIT {
        AWT,
        JAVAFX;


        static TOOLKIT get(String threadName) {
            if (threadName.startsWith("AWT-EventQueue")) {
                return AWT;
            }
            if (threadName.startsWith("JavaFX Application Thread")) {
                return JAVAFX;
            }
            return null;
        }
    }
}

