/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.results.DataFrameProcessor;
import org.netbeans.lib.profiler.results.ProfilingResultListener;

public abstract class AbstractDataFrameProcessor
implements DataFrameProcessor {
    protected static final Logger LOGGER = Logger.getLogger(DataFrameProcessor.class.getName());
    protected volatile ProfilerClient client = null;
    protected volatile boolean collectingTwoTimeStamps;
    private final Set listeners = new CopyOnWriteArraySet();
    private boolean processorLives = false;

    @Override
    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDataFrame(byte[] buffer) {
        ProfilerClient profilerClient = this.client;
        synchronized (profilerClient) {
            AbstractDataFrameProcessor abstractDataFrameProcessor = this;
            synchronized (abstractDataFrameProcessor) {
                if (!this.processorLives) {
                    return;
                }
                try {
                    this.fireBatchStart();
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Frame start, size=" + buffer.length);
                    }
                    this.collectingTwoTimeStamps = this.client != null ? this.client.getStatus().collectingTwoTimeStamps() : false;
                    this.doProcessDataFrame(ByteBuffer.wrap(buffer));
                }
                catch (Throwable e) {
                    LOGGER.log(Level.SEVERE, "Error while processing data frame", e);
                }
                finally {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Frame stop");
                    }
                    this.fireBatchStop();
                }
            }
        }
    }

    public void removeAllListeners() {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ProfilingResultListener)iter.next()).shutdown();
        }
        this.listeners.clear();
    }

    @Override
    public void reset() {
        this.fireReset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        AbstractDataFrameProcessor abstractDataFrameProcessor = this;
        synchronized (abstractDataFrameProcessor) {
            this.processorLives = false;
            this.fireShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup(ProfilerClient client) {
        AbstractDataFrameProcessor abstractDataFrameProcessor = this;
        synchronized (abstractDataFrameProcessor) {
            this.processorLives = true;
            this.client = client;
        }
    }

    protected void addListener(ProfilingResultListener listener) {
        this.listeners.add(listener);
    }

    protected abstract void doProcessDataFrame(ByteBuffer var1);

    protected static long getTimeStamp(ByteBuffer buffer) {
        long timestamp = ((long)buffer.get() & 0xFFL) << 48 | ((long)buffer.get() & 0xFFL) << 40 | ((long)buffer.get() & 0xFFL) << 32 | ((long)buffer.get() & 0xFFL) << 24 | ((long)buffer.get() & 0xFFL) << 16 | ((long)buffer.get() & 0xFFL) << 8 | (long)buffer.get() & 0xFFL;
        return timestamp;
    }

    protected static String getString(ByteBuffer buffer) {
        char strLen = buffer.getChar();
        byte[] str = new byte[strLen];
        buffer.get(str);
        return new String(str);
    }

    protected void fireProfilingPoint(final int threadId, final int ppId, final long timeStamp) {
        this.foreachListener(new ListenerFunctor(){
            final /* synthetic */ AbstractDataFrameProcessor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void execute(ProfilingResultListener listener) {
                listener.profilingPoint(threadId, ppId, timeStamp);
            }
        });
    }

    protected void fireReset() {
        this.foreachListener(new ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                listener.reset();
            }
        });
    }

    protected void foreachListener(ListenerFunctor functor) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            functor.execute((ProfilingResultListener)iter.next());
        }
    }

    protected void removeListener(ProfilingResultListener listener) {
        if (this.listeners.remove(listener)) {
            listener.shutdown();
        }
    }

    private void fireBatchStart() {
        this.foreachListener(new ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                listener.onBatchStart();
            }
        });
    }

    private void fireBatchStop() {
        this.foreachListener(new ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                listener.onBatchStop();
            }
        });
    }

    private void fireShutdown() {
        this.foreachListener(new ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                listener.shutdown();
            }
        });
    }

    protected static interface ListenerFunctor {
        public void execute(ProfilingResultListener var1);
    }
}

