/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.logging;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.netbeans.modules.payara.tooling.utils.JavaUtils;

public class Logger {
    private static final String LOGGER_NAME = "org.netbeans.modules.payara.tooling";
    static final String MESSAGES_FILE = "LogMessages";
    static final String EXCEPTIONS_FILE = "ExceptionMessages";
    static final String PROPERTIES_FILE_SUFFIX = ".properties";
    private static final char KEY_SEPARATOR = '.';
    private static final Map<Package, Properties> logProps = new HashMap<Package, Properties>();
    private static final Map<Package, Properties> excProps = new HashMap<Package, Properties>();
    private final String name;
    private final Class cl;
    private final java.util.logging.Logger logger;

    @Deprecated
    public static java.util.logging.Logger getLogger() {
        return java.util.logging.Logger.getLogger(LOGGER_NAME);
    }

    @Deprecated
    public static boolean loggable(Level level) {
        return Logger.getLogger().isLoggable(level);
    }

    @Deprecated
    public static void log(Level level, String msg, Throwable thrown) {
        Logger.getLogger().log(level, msg, thrown);
    }

    @Deprecated
    public static void log(Level level, String msg, Object param) {
        Logger.getLogger().log(level, msg, param);
    }

    @Deprecated
    public static void log(Level level, String msg, Object[] params) {
        Logger.getLogger().log(level, msg, params);
    }

    private static String buildPropertiesFileName(String file, boolean locales) {
        StringBuilder sb = new StringBuilder(file.length() + PROPERTIES_FILE_SUFFIX.length());
        sb.append(file);
        sb.append(PROPERTIES_FILE_SUFFIX);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String message(String file, Map<Package, Properties> propsMap, Class c, String key) {
        Properties props;
        Package pkg = c.getPackage();
        Map<Package, Properties> map = propsMap;
        synchronized (map) {
            props = propsMap.get(pkg);
            if (props == null) {
                props = new Properties();
                URL url = JavaUtils.getPropertiesURL(c, Logger.buildPropertiesFileName(file, false));
                if (url != null) {
                    try {
                        url.openStream();
                        props.load(url.openStream());
                    }
                    catch (IOException ioe) {
                        props = new Properties();
                    }
                }
                propsMap.put(pkg, props);
            }
        }
        String property = props.getProperty(key);
        return property != null ? property : key;
    }

    public static String logMsg(Class c, String key) {
        return Logger.message(MESSAGES_FILE, logProps, c, key);
    }

    public static String excMsg(Class c, String key) {
        return Logger.message(EXCEPTIONS_FILE, excProps, c, key);
    }

    public Logger(Class c) {
        this.name = c.getName();
        this.cl = c;
        this.logger = java.util.logging.Logger.getLogger(this.name);
    }

    public String buildKey(String method, String key) {
        if (method == null || key == null) {
            throw new IllegalArgumentException("Key value shall not be null.");
        }
        String clName = this.cl.getSimpleName();
        StringBuilder sb = new StringBuilder(clName.length() + method.length() + key.length() + 2);
        sb.append(clName);
        sb.append('.');
        sb.append(method);
        sb.append('.');
        sb.append(key);
        return sb.toString();
    }

    public String excMsg(String method, String key) {
        return Logger.message(EXCEPTIONS_FILE, excProps, this.cl, this.buildKey(method, key));
    }

    public String excMsg(String method, String key, String ... attrs) {
        String message = Logger.message(EXCEPTIONS_FILE, excProps, this.cl, this.buildKey(method, key));
        return MessageFormat.format(message, attrs);
    }

    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    public void log(Level level, String method, String key) {
        this.logger.log(level, Logger.logMsg(this.cl, this.buildKey(method, key)));
    }

    public void log(Level level, String method, String key, Throwable thrown) {
        this.logger.log(level, Logger.logMsg(this.cl, this.buildKey(method, key)), thrown);
    }

    public void log(Level level, String method, String key, Object param) {
        this.logger.log(level, Logger.logMsg(this.cl, this.buildKey(method, key)), param);
    }

    public void log(Level level, String method, String key, Object[] params) {
        this.logger.log(level, Logger.logMsg(this.cl, this.buildKey(method, key)), params);
    }

    public void exception(Level level, String message) {
        this.logger.log(level, message);
    }
}

