/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.UIResource;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleProperties;
import org.openide.util.WeakListeners;

public class JavaPlatformComponentFactory {
    private JavaPlatformComponentFactory() {
    }

    public static ComboBoxModel javaPlatformListModel() {
        return new Model();
    }

    public static ListCellRenderer javaPlatformListCellRenderer() {
        return new Renderer();
    }

    private static final class Model
    implements ComboBoxModel,
    PropertyChangeListener,
    Comparator<JavaPlatform> {
        private static final Collator COLL = Collator.getInstance();
        private static final JavaPlatformManager mgr = JavaPlatformManager.getDefault();
        private final SortedSet<JavaPlatform> platforms = new TreeSet<JavaPlatform>(this);
        private final List<ListDataListener> listeners = new ArrayList<ListDataListener>();
        private JavaPlatform selected;

        public Model() {
            this.refresh();
            mgr.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)mgr));
        }

        private void refresh() {
            this.platforms.clear();
            for (JavaPlatform plaf : mgr.getInstalledPlatforms()) {
                if (!plaf.getSpecification().getName().equals("j2se")) continue;
                this.platforms.add(plaf);
            }
        }

        @Override
        public int getSize() {
            return this.platforms.size();
        }

        @Override
        public Object getElementAt(int index) {
            return new ArrayList<JavaPlatform>(this.platforms).get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        @Override
        public void setSelectedItem(Object sel) {
            if (sel != this.selected) {
                this.selected = (JavaPlatform)sel;
                this.fireChange();
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        private void fireChange() {
            ListDataEvent ev = new ListDataEvent(this, 0, 0, 0);
            for (ListDataListener l : new ArrayList<ListDataListener>(this.listeners)) {
                l.contentsChanged(ev);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.refresh();
            this.fireChange();
        }

        @Override
        public int compare(JavaPlatform p1, JavaPlatform p2) {
            int res = COLL.compare(p1.getDisplayName(), p2.getDisplayName());
            if (res != 0) {
                return res;
            }
            String id1 = ModuleProperties.getPlatformID(p1);
            String id2 = ModuleProperties.getPlatformID(p2);
            if (id1 != null && id2 != null) {
                return id1.compareTo(id2);
            }
            return System.identityHashCode(p1) - System.identityHashCode(p2);
        }
    }

    private static final class Renderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public Renderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            String name = value != null ? ((JavaPlatform)value).getDisplayName() : null;
            this.setText(name);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }
}

