Metasploit Framework 6.0 is in progress!

Metasploit 6.0 adds a number of features and promotes a theme of being "secure by default".

See the release initial announcement [here](https://blog.rapid7.com/2020/08/06/metasploit-6-now-under-active-development/).

## Payload Improvements

Quite a few payload improvements have been made, most but not all have been for the Meterpreter payload and it's various implementations. Among other things, it was updated to support AES encryption in CBC mode in _all_ implementations on _all_ transports. This helps to secure framework users data in transit. Now any files transferred, commands issued, etc. are encrypted on the network using a AES and a key negotiated via RSA.

This helps remove static strings from network traffic, but it's not the only change targeting obfuscation. Each of the Meterpreter commands were replaced with an integer equivalent, thus removing conspicuous values such as `stdapi_fs_file_copy`, `core_migrate` and `mimikatz_custom_command`. Additionally, the payload binaries were updated to utilize functions by ordinal value rather than by name. This allows them to be called without disclosing their own conspicuous values such as `RefletiveLoader`, `ext_server_`, etc. Lastly, the static "Block API" used by almost all x86 and x64 Windows shellcode payloads was updated to be polymorphic, causing it to be randomized on each invocation. In some payloads, the  Block API accounts for as much as half of the shellcode and was an easy target for signature-based detection.

All of these changes mark strides towards complicating the identification of key artifacts generated by Metasploit via static analysis, ie. signatures.

### Compatibility Changes

Metasploit 6 drops Meterpreter support for Windows versions older than XP SP2. This service pack adds a number of API methods that are required by Meterpreter and backporting compatibility is not a priority at this time. The Meterpreter stage will fail to load on these older, unsupported versions. This results in a message saying that the session was closed.

## SMB 3

Metasploit 6 adds support for SMB client connections using the version 3 dialects. This adds compatibility for a large pool of modules to work in environments where SMB version 1 and 2 have been disabled. Additionally, one of the most notable improvements of the version 3 dialects is encryption support, which when negotiated allows the framework to secure it's connections to compatible SMB servers. SMB version 3, which was added in Windows 8 and Server 2012 incorporates a few security improvements leading to many organizations migrating towards its exclusive use within their environments.

While many modules were updated to use the RubySMB SMB 3 implementation, not all were updated. Notably many older exploits that pre-date the release of SMB 3 were not updated and continue to use the original Rex implementation of the protocol. For those modules that have been updated however, users will be able to use them without any changes to their work flow. By default the newest dialect will be negotiated with the remote server and if it is one of the dialects within version 3 that supports encryption, the framework will use encryption by default. Users can alter this behavior by setting the `SMB::AlwaysEncrypt` and `SMB::ProtocolVersion` options. `SMB::AlwaysEncrypt` enforces encryption for SMB 3 connections even when the server does not require it (defaults to: `true`) while `SMB::ProtocolVersion` is a comma separated list of versions to allow the framework to negotiate (default: `1,2,3`).

Module authors looking to write SMB modules should note the move towards the [RubySMB](https://github.com/rapid7/ruby_smb) protocol stack instead of the legacy Rex implementation. Much of the functionality is standardized within the [mixins](https://github.com/rapid7/metasploit-framework/tree/master/lib/msf/core/exploit/smb) however some edge-case functionality must still be ported over to RubySMB. For information on writing modules target SMB for Metasploit, see [[Guidelines for Writing Modules with SMB|./Guidelines-for-Writing-Modules-with-SMB.md]].

## Pull Requests

A complete list of pull requests included as part of the initial version 6 work:

* Payload Improvements
    * Add AES TLV encryption support: [Java](https://github.com/rapid7/metasploit-payloads/pull/400), [Python](https://github.com/rapid7/metasploit-framework/pull/13432)
        * Support AES-128-CBC as an additional option: [Framework Core](https://github.com/rapid7/metasploit-framework/pull/13783), [Java](https://github.com/rapid7/metasploit-payloads/pull/418)
        * Change from PEM to DER for crypt TLV negotiation: [Windows, Java, PHP](https://github.com/rapid7/metasploit-payloads/pull/397), [Framework Core](https://github.com/rapid7/metasploit-framework/pull/13400), [mettle](https://github.com/rapid7/mettle/pull/197), [Python](https://github.com/rapid7/metasploit-payloads/pull/415)
    * Remove DLL exports from Meterpreter: [Windows](https://github.com/rapid7/metasploit-payloads/pull/401) [Framework Core](https://github.com/rapid7/metasploit-framework/pull/13476), [ReflectiveDLLInjection](https://github.com/rapid7/ReflectiveDLLInjection/pull/9)
    * Replace METHOD string with COMMAND_ID integer (to remove obvious strings): [Framework Core](https://github.com/rapid7/metasploit-framework/pull/13395), [Windows, Java, PHP, Python](https://github.com/rapid7/metasploit-payloads/pull/395)
    * [Cross-compile Windows binaries on Linux](https://github.com/rapid7/metasploit-payloads/pull/405)
        * [Various changes required for cross compilation](https://github.com/rapid7/mimikatz/pull/4)
        * [Update readme for cross compilation](https://github.com/rapid7/metasploit-payloads/pull/419)
    * Remove the old Mimikatz extension: [Windows](https://github.com/rapid7/metasploit-payloads/pull/404), [Framework Core](https://github.com/rapid7/metasploit-framework/pull/13529)
    * [Polymorphic x86/x64 Block API](https://github.com/rapid7/metasploit-framework/pull/13832)
* Add SMBv3 support: [ruby_smb](https://github.com/rapid7/ruby_smb/pull/154), [Framework Core](https://github.com/rapid7/metasploit-framework/pull/13417)
    * [Fixes and improvements from MSF code review](https://github.com/rapid7/ruby_smb/pull/156)
    * [Store server system and start time values](https://github.com/rapid7/ruby_smb/pull/155)
* [Add a command target to the PSexec module](https://github.com/rapid7/metasploit-framework/pull/13812)

## Get Metasploit 6.0

You can get Metasploit 6.0 by checking out the [6.0.0 tag](https://github.com/rapid7/metasploit-framework/releases/tag/6.0.0) in the Metasploit GitHub project.

Need a primer on Framework architecture and usage? Take a look at [our wiki here](https://docs.metasploit.com/), and feel free to reach out to the broader community [on Slack](https://metasploit.com/slack). There are also myriad public and user-generated resources on Metasploit tips, tricks, and content, so if you can't find something you want in our wiki, ask Google or the community what they recommend.

See all the ways to stay informed and get involved at <https://metasploit.com>.
