# -*- coding: binary -*-

module Msf
  class Exploit
    class Remote
      module HTTP
        module Kubernetes
          module Error
            class ApiError < ::StandardError
              def initialize(message: nil, res: nil)
                super(message || "Kubernetes ApiError")
                @res = res
              end

              attr_reader :res
            end

            class InvalidApiError < ApiError
              def initialize(message: nil, res: nil)
                super(message: message || "Kubernetes InvalidApi - target does not appear to be running Kubernetes, verify configuration", res: res)
                @res = res
              end

              attr_reader :res
            end

            class AuthenticationError < ApiError
              def initialize(message: nil, res: nil)
                super(message: message || "Kubernetes AuthenticationError - token may be invalid", res: res)
              end
            end

            class ForbiddenError < ApiError
              def initialize(message: nil, res: nil)
                super(message: message || "Kubernetes ForbiddenError - token does not have permission to access this resource", res: res)
              end
            end

            class NotFoundError < ApiError
              def initialize(message: nil, res: nil)
                super(message: message || "Kubernetes NotFoundError - resource not found", res: res)
              end
            end

            class ServerError < ApiError
              def initialize(message: nil, res: nil)
                super(message: message || server_error_for(res), res: res)
              end

              protected

              def server_error_for(res)
                json = res.get_json_document
                return "Kubernetes ServerError #{res.code}" if json.nil?

                "Kubernetes ServerError #{res.code} - #{json.fetch('message', 'Failure')} "
              end
            end

            class UnexpectedStatusCode < ApiError
              attr_reader :status_code
              def initialize(message: nil, res: nil)
                @status_code = res.code
                super(message: message || "Kubernetes ApiError - unexpected response status code #{status_code}", res: res)
              end
            end
          end
        end
      end
    end
  end
end
