/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.dirtyFiles;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.CompilationTransaction;
import org.jetbrains.kotlin.incremental.CompilationTransactionKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/incremental/dirtyFiles/DirtyFilesCachedHistory;", "", "workingDir", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "dirtySourcesSinceLastTimeFile", "store", "", "withTransaction", "Lorg/jetbrains/kotlin/incremental/CompilationTransaction;", "allDirtySources", "", "read", "", "clear", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nDirtyFilesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirtyFilesProvider.kt\norg/jetbrains/kotlin/incremental/dirtyFiles/DirtyFilesCachedHistory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1586#2:61\n1661#2,3:62\n*S KotlinDebug\n*F\n+ 1 DirtyFilesProvider.kt\norg/jetbrains/kotlin/incremental/dirtyFiles/DirtyFilesCachedHistory\n*L\n32#1:61\n32#1:62,3\n*E\n"})
public final class DirtyFilesCachedHistory {
    @NotNull
    private final File dirtySourcesSinceLastTimeFile;

    public DirtyFilesCachedHistory(@NotNull File workingDir) {
        Intrinsics.checkNotNullParameter(workingDir, "workingDir");
        this.dirtySourcesSinceLastTimeFile = new File(workingDir, "dirty-sources.txt");
    }

    public final void store(@NotNull CompilationTransaction withTransaction, @NotNull Collection<? extends File> allDirtySources) {
        Intrinsics.checkNotNullParameter(withTransaction, "withTransaction");
        Intrinsics.checkNotNullParameter(allDirtySources, "allDirtySources");
        Iterable iterable = allDirtySources;
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue(string, "lineSeparator(...)");
        String text = CollectionsKt.joinToString$default(iterable, string, null, null, 0, null, DirtyFilesCachedHistory::store$lambda$0, 30, null);
        Path path = this.dirtySourcesSinceLastTimeFile.toPath();
        Intrinsics.checkNotNullExpressionValue(path, "toPath(...)");
        CompilationTransactionKt.writeText(withTransaction, path, text);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> read() {
        if (this.dirtySourcesSinceLastTimeFile.exists()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = FilesKt.readLines$default(this.dirtySourcesSinceLastTimeFile, null, 1, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new File((String)p0));
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    public final void clear(@NotNull CompilationTransaction withTransaction) {
        Intrinsics.checkNotNullParameter(withTransaction, "withTransaction");
        Path path = this.dirtySourcesSinceLastTimeFile.toPath();
        Intrinsics.checkNotNullExpressionValue(path, "toPath(...)");
        withTransaction.deleteFile(path);
    }

    private static final CharSequence store$lambda$0(File it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string = FilesKt.normalize(it).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(string, "getAbsolutePath(...)");
        return string;
    }
}

