/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Objects;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.boot.model.internal.AnnotatedJoinColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.AttributeContainer;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Fetchable;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SortableValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.type.EntityType;
import org.hibernate.type.MappingContext;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class ToOne
extends SimpleValue
implements Fetchable,
SortableValue {
    private FetchMode fetchMode;
    protected String referencedPropertyName;
    private String referencedEntityName;
    private String propertyName;
    private boolean lazy = true;
    private boolean sorted;
    private boolean unwrapProxy;
    private boolean unwrapProxyImplicit;
    private boolean referenceToPrimaryKey = true;

    protected ToOne(MetadataBuildingContext buildingContext, Table table) {
        super(buildingContext, table);
    }

    protected ToOne(ToOne original) {
        super(original);
        this.fetchMode = original.fetchMode;
        this.referencedPropertyName = original.referencedPropertyName;
        this.referencedEntityName = original.referencedEntityName;
        this.propertyName = original.propertyName;
        this.lazy = original.lazy;
        this.sorted = original.sorted;
        this.unwrapProxy = original.unwrapProxy;
        this.unwrapProxyImplicit = original.unwrapProxyImplicit;
        this.referenceToPrimaryKey = original.referenceToPrimaryKey;
    }

    @Override
    public FetchMode getFetchMode() {
        return this.fetchMode;
    }

    @Override
    public void setFetchMode(FetchMode fetchMode) {
        this.fetchMode = fetchMode;
    }

    public String getReferencedPropertyName() {
        return this.referencedPropertyName;
    }

    public void setReferencedPropertyName(String name) {
        this.referencedPropertyName = name == null ? null : name.intern();
    }

    public String getReferencedEntityName() {
        return this.referencedEntityName;
    }

    public void setReferencedEntityName(String referencedEntityName) {
        this.referencedEntityName = referencedEntityName == null ? null : referencedEntityName.intern();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName == null ? null : propertyName.intern();
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) throws MappingException {
        if (this.referencedEntityName == null) {
            ClassLoaderService cls = this.getBuildingContext().getBootstrapContext().getClassLoaderService();
            this.referencedEntityName = ReflectHelper.reflectedPropertyClass(className, propertyName, cls).getName();
        }
    }

    @Override
    public boolean isTypeSpecified() {
        return this.referencedEntityName != null;
    }

    @Override
    public boolean isSame(SimpleValue other) {
        ToOne toOne;
        return other instanceof ToOne && this.isSame(toOne = (ToOne)other);
    }

    public boolean isSame(ToOne other) {
        return super.isSame(other) && Objects.equals(this.referencedPropertyName, other.referencedPropertyName) && Objects.equals(this.referencedEntityName, other.referencedEntityName);
    }

    @Override
    public boolean isValid(MappingContext mappingContext) throws MappingException {
        if (this.referencedEntityName == null) {
            throw new MappingException("association must specify the referenced entity");
        }
        return super.isValid(mappingContext);
    }

    @Override
    public boolean isLazy() {
        return this.lazy;
    }

    @Override
    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public boolean isUnwrapProxy() {
        return this.unwrapProxy;
    }

    public void setUnwrapProxy(boolean unwrapProxy) {
        this.unwrapProxy = unwrapProxy;
    }

    public boolean isUnwrapProxyImplicit() {
        return this.unwrapProxyImplicit;
    }

    public void setUnwrapProxyImplicit(boolean unwrapProxyImplicit) {
        this.unwrapProxyImplicit = unwrapProxyImplicit;
    }

    public boolean isReferenceToPrimaryKey() {
        return this.referenceToPrimaryKey;
    }

    public void setReferenceToPrimaryKey(boolean referenceToPrimaryKey) {
        this.referenceToPrimaryKey = referenceToPrimaryKey;
    }

    @Override
    public boolean isSorted() {
        return this.sorted;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    @Override
    public int[] sortProperties() {
        PersistentClass entityBinding = this.getMetadata().getEntityBinding(this.referencedEntityName);
        if (entityBinding != null) {
            KeyValue value;
            Value value2 = value = this.referencedPropertyName == null ? entityBinding.getIdentifier() : entityBinding.getRecursiveProperty(this.referencedPropertyName).getValue();
            if (value instanceof Component) {
                Component component = (Component)value;
                int[] originalPropertyOrder = component.sortProperties();
                if (!this.sorted) {
                    if (originalPropertyOrder != null) {
                        this.sortColumns(originalPropertyOrder);
                    }
                    this.sorted = true;
                }
                return originalPropertyOrder;
            }
            this.sorted = true;
        }
        return null;
    }

    @Override
    public void createForeignKey(PersistentClass referencedEntity, AnnotatedJoinColumns joinColumns) {
        this.sortProperties();
        if (this.isForeignKeyEnabled() && this.referencedPropertyName == null && !this.hasFormula() && this.isConstrained()) {
            AnnotatedJoinColumn firstColumn = joinColumns.getJoinColumns().get(0);
            AttributeContainer owner = BinderHelper.findReferencedColumnOwner(referencedEntity, firstColumn, this.getBuildingContext());
            if (owner instanceof Join) {
                Join join = (Join)owner;
                ForeignKey foreignKey = this.getTable().createForeignKey(this.getForeignKeyName(), this.getConstraintColumns(), referencedEntity.getEntityName(), this.getForeignKeyDefinition(), this.getForeignKeyOptions(), join.getKey().getColumns());
                foreignKey.setOnDeleteAction(this.getOnDeleteAction());
                foreignKey.setReferencedTable(join.getTable());
            } else {
                this.createForeignKeyOfEntity(referencedEntity.getEntityName());
            }
        }
    }

    @Override
    public void createForeignKey() {
        this.sortProperties();
        if (this.isForeignKeyEnabled() && this.referencedPropertyName == null && !this.hasFormula()) {
            this.createForeignKeyOfEntity(((EntityType)this.getType()).getAssociatedEntityName());
        }
    }
}

