/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.pdb;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import org.jmol.adapter.readers.pdb.PdbReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.script.ScriptEval;
import org.jmol.script.ScriptException;
import org.jmol.script.T;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.Vibration;
import org.jmol.viewer.Viewer;

public class JmolDataReader
extends PdbReader {
    private Map<String, float[]> props;
    private String[] residueNames;
    private String[] atomNames;
    private boolean isSpin;
    private float spinFactor;
    private int originatingModel = -1;
    private String jmolDataHeader;
    private P3[] jmolDataScaling;

    @Override
    protected void checkRemark() {
        if (this.line.length() >= 30 && this.line.indexOf("Jmol") == 11) {
            switch ("Ppard".indexOf(this.line.substring(16, 17))) {
                case 0: {
                    this.props = new Hashtable<String, float[]>();
                    this.isSpin = this.line.indexOf(": spin;") >= 0;
                    this.originatingModel = -1;
                    int pt = this.line.indexOf("for model ");
                    if (pt > 0) {
                        this.originatingModel = PT.parseInt(this.line.substring(pt + 10));
                    }
                    this.jmolDataHeader = this.line;
                    if (this.line.endsWith("#noautobond")) break;
                    this.line = this.line + "#noautobond";
                    break;
                }
                case 1: {
                    int pt1 = this.line.indexOf("[");
                    int pt2 = this.line.indexOf("]");
                    if (pt1 < 25 || pt2 <= pt1) {
                        return;
                    }
                    String name = this.line.substring(25, pt1).trim();
                    this.line = this.line.substring(pt1 + 1, pt2).replace(',', ' ');
                    String[] tokens = this.getTokens();
                    Logger.info("reading " + name + " " + tokens.length);
                    float[] prop = new float[tokens.length];
                    int i = prop.length;
                    while (--i >= 0) {
                        prop[i] = this.parseFloatStr(tokens[i]);
                    }
                    this.props.put(name, prop);
                    break;
                }
                case 2: {
                    this.line = this.line.substring(27);
                    this.atomNames = this.getTokens();
                    Logger.info("reading atom names " + this.atomNames.length);
                    break;
                }
                case 3: {
                    this.line = this.line.substring(30);
                    this.residueNames = this.getTokens();
                    Logger.info("reading residue names " + this.residueNames.length);
                    break;
                }
                case 4: {
                    Logger.info(this.line);
                    float[] data = new float[15];
                    Parser.parseStringInfestedFloatArray(this.line.substring(10).replace('=', ' ').replace('{', ' ').replace('}', ' '), null, data);
                    P3 minXYZ = P3.new3(data[0], data[1], data[2]);
                    P3 maxXYZ = P3.new3(data[3], data[4], data[5]);
                    this.fileScaling = P3.new3(data[6], data[7], data[8]);
                    this.fileOffset = P3.new3(data[9], data[10], data[11]);
                    P3 plotScale = P3.new3(data[12], data[13], data[14]);
                    if (plotScale.x <= 0.0f) {
                        plotScale.x = 100.0f;
                    }
                    if (plotScale.y <= 0.0f) {
                        plotScale.y = 100.0f;
                    }
                    if (plotScale.z <= 0.0f) {
                        plotScale.z = 100.0f;
                    }
                    if (this.fileScaling.y == 0.0f) {
                        this.fileScaling.y = 1.0f;
                    }
                    if (this.fileScaling.z == 0.0f) {
                        this.fileScaling.z = 1.0f;
                    }
                    if (this.isSpin) {
                        this.spinFactor = plotScale.x / maxXYZ.x;
                    } else {
                        this.setFractionalCoordinates(true);
                        this.latticeCells = new int[4];
                        this.asc.xtalSymmetry = null;
                        this.setUnitCell(plotScale.x * 2.0f / (maxXYZ.x - minXYZ.x), plotScale.y * 2.0f / (maxXYZ.y - minXYZ.y), plotScale.z * 2.0f / (maxXYZ.z == minXYZ.z ? 1.0f : maxXYZ.z - minXYZ.z), 90.0f, 90.0f, 90.0f);
                        this.unitCellOffset = P3.newP(plotScale);
                        this.unitCellOffset.scale(-1.0f);
                        this.getSymmetry();
                        this.symmetry.toFractional(this.unitCellOffset, false);
                        this.unitCellOffset.scaleAdd2(-1.0f, minXYZ, this.unitCellOffset);
                        this.symmetry.setOffsetPt(this.unitCellOffset);
                        this.doApplySymmetry = true;
                    }
                    this.jmolDataScaling = new P3[]{minXYZ, maxXYZ, plotScale};
                }
            }
        }
        this.checkCurrentLineForScript();
    }

    @Override
    protected void processAtom2(Atom atom, int serial, float x, float y, float z, int charge) {
        if (this.isSpin) {
            Vibration vib = new Vibration();
            vib.set(x, y, z);
            vib.isFrom000 = true;
            atom.vib = vib;
            x *= this.spinFactor;
            y *= this.spinFactor;
            z *= this.spinFactor;
        }
        super.processAtom2(atom, serial, x, y, z, charge);
    }

    @Override
    protected void setAdditionalAtomParameters(Atom atom) {
        if (this.residueNames != null && atom.index < this.residueNames.length) {
            atom.group3 = this.residueNames[atom.index];
        }
        if (this.atomNames != null && atom.index < this.atomNames.length) {
            atom.atomName = this.atomNames[atom.index];
        }
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        if (this.jmolDataHeader == null) {
            return;
        }
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("header", this.jmolDataHeader);
        info.put("originatingModel", this.originatingModel);
        info.put("properties", this.props);
        info.put("jmolDataScaling", this.jmolDataScaling);
        this.asc.setInfo("jmolData", info);
        this.finalizeReaderPDB();
    }

    public String[] getJmolDataFrameScripts(Viewer vwr, int tok, int modelIndex, int modelCount, String type, String qFrame, String[] props, boolean isSpinPointGroup) {
        String script;
        String script2 = null;
        switch (tok) {
            default: {
                script = "frame 0.0; frame last; reset;select visible;wireframe only;";
                break;
            }
            case 1715472409: {
                vwr.setFrameTitle(modelCount - 1, type + " plot for model " + vwr.getModelNumberDotted(modelIndex));
                script = "frame 0.0; frame last; reset;select visible; spacefill 3.0; wireframe 0;draw plotAxisX" + modelCount + " {100 -100 -100} {-100 -100 -100} \"" + props[0] + "\";draw plotAxisY" + modelCount + " {-100 100 -100} {-100 -100 -100} \"" + props[1] + "\";";
                if (props[2] == null) break;
                script = script + "draw plotAxisZ" + modelCount + " {-100 -100 100} {-100 -100 -100} \"" + props[2] + "\";";
                break;
            }
            case 4138: {
                vwr.setFrameTitle(modelCount - 1, "ramachandran plot for model " + vwr.getModelNumberDotted(modelIndex));
                script = "frame 0.0; frame last; reset;select visible; color structure; spacefill 3.0; wireframe 0;draw ramaAxisX" + modelCount + " {100 0 0} {-100 0 0} \"phi\";draw ramaAxisY" + modelCount + " {0 100 0} {0 -100 0} \"psi\";";
                break;
            }
            case 134221850: 
            case 136314895: {
                vwr.setFrameTitle(modelCount - 1, type.replace('w', ' ') + qFrame + " for model " + vwr.getModelNumberDotted(modelIndex));
            }
            case 1095241729: {
                String color = C.getHexCode(vwr.cm.colixBackgroundContrast);
                script = "frame 0.0; frame last; reset;select visible; wireframe 0; spacefill 3.0; isosurface quatSphere" + modelCount + " color " + color + " sphere 100.0 mesh nofill frontonly translucent 0.8;draw quatAxis" + modelCount + "X {100 0 0} {-100 0 0} color red \"x\";draw quatAxis" + modelCount + "Y {0 100 0} {0 -100 0} color green \"y\";draw quatAxis" + modelCount + "Z {0 0 100} {0 0 -100} color blue \"z\";" + (tok == 1095241729 ? "vectors 2.0;spacefill off;" : "color structure;") + "draw quatCenter" + modelCount + "{0 0 0} scale 0.02;";
                if (!isSpinPointGroup) break;
                script2 = ";set symmetryhm;draw spin pointgroup;var name = {2.1}.pointgroup().hmName;set echo hmname 100% 100%;set echo hmname RIGHT;set echo hmname model 2.1;echo @name;";
            }
        }
        return new String[]{script, script2};
    }

    public Object[] getJmolDataFrameProperties(ScriptEval e, int tok, int[] propToks, String[] props, BS bs, P3 minXYZ, P3 maxXYZ, String format, boolean isPdbFormat) throws ScriptException {
        float pdbFactor = 1.0f;
        float[] dataX = null;
        float[] dataY = null;
        float[] dataZ = null;
        dataX = e.getBitsetPropertyFloat(bs, propToks[0] | 0xE0, propToks[0] == 1715472409 ? props[0] : null, minXYZ == null ? Float.NaN : minXYZ.x, maxXYZ == null ? Float.NaN : maxXYZ.x);
        String[] propData = new String[3];
        propData[0] = props[0] + " " + Escape.eAF(dataX);
        if (props[1] != null) {
            dataY = e.getBitsetPropertyFloat(bs, propToks[1] | 0xE0, propToks[1] == 1715472409 ? props[1] : null, minXYZ == null ? Float.NaN : minXYZ.y, maxXYZ == null ? Float.NaN : maxXYZ.y);
            propData[1] = props[1] + " " + Escape.eAF(dataY);
        }
        if (props[2] != null) {
            dataZ = e.getBitsetPropertyFloat(bs, propToks[2] | 0xE0, propToks[2] == 1715472409 ? props[2] : null, minXYZ == null ? Float.NaN : minXYZ.z, maxXYZ == null ? Float.NaN : maxXYZ.z);
            propData[2] = props[2] + " " + Escape.eAF(dataZ);
        }
        if (minXYZ == null) {
            minXYZ = P3.new3(JmolDataReader.getPlotMinMax(dataX, false, propToks[0]), JmolDataReader.getPlotMinMax(dataY, false, propToks[1]), JmolDataReader.getPlotMinMax(dataZ, false, propToks[2]));
        }
        if (maxXYZ == null) {
            maxXYZ = P3.new3(JmolDataReader.getPlotMinMax(dataX, true, propToks[0]), JmolDataReader.getPlotMinMax(dataY, true, propToks[1]), JmolDataReader.getPlotMinMax(dataZ, true, propToks[2]));
        }
        Logger.info("plot min/max: " + minXYZ + " " + maxXYZ);
        P3 center = null;
        P3 factors = null;
        if (isPdbFormat) {
            int i;
            factors = P3.new3(1.0f, 1.0f, 1.0f);
            center = new P3();
            center.ave(maxXYZ, minXYZ);
            factors.sub2(maxXYZ, minXYZ);
            if (tok != 1095241729) {
                factors.set(factors.x / 200.0f, factors.y / 200.0f, factors.z / 200.0f);
            }
            if (T.tokAttr(propToks[0], 0x41400000)) {
                factors.x = 1.0f;
                center.x = 0.0f;
            } else if ((double)factors.x > 0.1 && factors.x <= 10.0f) {
                factors.x = 1.0f;
            }
            if (T.tokAttr(propToks[1], 0x41400000)) {
                factors.y = 1.0f;
                center.y = 0.0f;
            } else if ((double)factors.y > 0.1 && factors.y <= 10.0f) {
                factors.y = 1.0f;
            }
            if (T.tokAttr(propToks[2], 0x41400000)) {
                factors.z = 1.0f;
                center.z = 0.0f;
            } else if ((double)factors.z > 0.1 && factors.z <= 10.0f) {
                factors.z = 1.0f;
            }
            if (props[2] == null || props[1] == null) {
                factors.z = 0.0f;
                maxXYZ.z = 0.0f;
                minXYZ.z = 0.0f;
                center.z = 0.0f;
            }
            for (i = 0; i < dataX.length; ++i) {
                dataX[i] = (dataX[i] - center.x) / factors.x * pdbFactor;
            }
            if (props[1] != null) {
                for (i = 0; i < dataY.length; ++i) {
                    dataY[i] = (dataY[i] - center.y) / factors.y * pdbFactor;
                }
            }
            if (props[2] != null) {
                for (i = 0; i < dataZ.length; ++i) {
                    dataZ[i] = (dataZ[i] - center.z) / factors.z * pdbFactor;
                }
            }
        }
        return new Object[]{bs, dataX, dataY, dataZ, minXYZ, maxXYZ, factors, center, format, propData, Float.valueOf(1.0f)};
    }

    private static float getPlotMinMax(float[] data, boolean isMax, int tok) {
        if (data == null) {
            return 0.0f;
        }
        switch (tok) {
            case 1111490568: 
            case 1111490569: 
            case 1111490570: {
                return isMax ? 180 : -180;
            }
            case 1111490565: 
            case 1111490576: {
                return isMax ? 360 : 0;
            }
            case 1111490574: {
                return isMax ? 1 : -1;
            }
        }
        float fmax = isMax ? -1.0E10f : 1.0E10f;
        int i = data.length;
        while (--i >= 0) {
            float f = data[i];
            if (Float.isNaN(f) || isMax != f > fmax) continue;
            fmax = f;
        }
        return fmax;
    }

    public void setJmolDataFrame(ModelSet ms, String type, int modelIndex, int modelDataIndex) {
        ms.haveJmolDataFrames = true;
        Model mdata = ms.am[modelDataIndex];
        Model model0 = ms.am[type == null ? mdata.dataSourceFrame : modelIndex];
        if (type == null) {
            type = mdata.jmolFrameType;
        }
        if (modelIndex >= 0) {
            if (model0.dataFrames == null) {
                model0.dataFrames = new Hashtable<String, Integer>();
            }
            mdata.dataSourceFrame = modelIndex;
            mdata.jmolFrameType = type;
            model0.dataFrames.put(type, modelDataIndex);
            if (mdata.jmolFrameTypeInt == 134221850 && type.indexOf("deriv") < 0) {
                type = type.substring(0, type.indexOf(" "));
                model0.dataFrames.put(type, modelDataIndex);
            }
            mdata.uvw0 = (P3[])ms.getModelAuxiliaryInfo(modelIndex).get("pointGroupAxes");
            if (mdata.uvw0 != null) {
                mdata.uvw0[0].scale(105.0f);
                mdata.uvw0[1].scale(105.0f);
                mdata.uvw0[2].scale(105.0f);
                mdata.uvw = new P3[]{P3.newP(mdata.uvw0[0]), P3.newP(mdata.uvw0[1]), P3.newP(mdata.uvw0[2])};
            }
        }
    }

    public BS getPlotSpinSet(Viewer vwr, BS bs, int modelIndex, P3 minXYZ, P3 maxXYZ) {
        if (bs.nextSetBit(0) < 0) {
            bs = vwr.getModelUndeletedAtomsBitSet(modelIndex);
        }
        if (bs.isEmpty()) {
            return null;
        }
        float len = 0.0f;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            Vibration v = vwr.ms.getVibration(i, false);
            if (v == null) {
                bs.clear(i);
            } else {
                len = Math.max(len, v.length());
            }
            i = bs.nextSetBit(i + 1);
        }
        if (len == 0.0f) {
            return null;
        }
        minXYZ.set(-len, -len, -len);
        maxXYZ.set(len, len, len);
        Lst<Vibration> lst = new Lst<Vibration>();
        int i2 = bs.nextSetBit(0);
        while (i2 >= 0) {
            Vibration v = vwr.ms.getVibration(i2, false);
            boolean found = false;
            int j = lst.size();
            while (--j >= 0) {
                if (!(v.distance((T3)lst.get(j)) < 0.1f)) continue;
                found = true;
                bs.clear(i2);
                break;
            }
            if (!found) {
                lst.addLast(v);
            }
            i2 = bs.nextSetBit(i2 + 1);
        }
        return bs;
    }
}

