/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.internal.tasks.compile.ContextAwareJavaCompiler;
import org.gradle.api.internal.tasks.compile.JdkTools;
import org.gradle.internal.Factory;

public class JavaHomeBasedJavaCompilerFactory
implements Factory<ContextAwareJavaCompiler>,
Serializable {
    private final List<File> compilerPluginsClasspath;
    private static final transient Map<List<File>, JdkTools> JDK_TOOLS = new ConcurrentHashMap<List<File>, JdkTools>();

    public JavaHomeBasedJavaCompilerFactory(List<File> compilerPluginsClasspath) {
        this.compilerPluginsClasspath = compilerPluginsClasspath;
    }

    public ContextAwareJavaCompiler create() {
        JdkTools jdkTools = JDK_TOOLS.computeIfAbsent(this.compilerPluginsClasspath, JavaHomeBasedJavaCompilerFactory::createJdkTools);
        return jdkTools.getSystemJavaCompiler();
    }

    private static JdkTools createJdkTools(List<File> compilerPluginsClasspath) {
        return new JdkTools(compilerPluginsClasspath);
    }
}

