/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform.shape;

import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Set;

public class Intersector {
    protected Rectangle rectangle;
    Line2D line;
    Set<Point2D> points = new HashSet<Point2D>();

    public Intersector(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    public Intersector(Rectangle rectangle, Line2D line) {
        this.rectangle = rectangle;
        this.intersectLine(line);
    }

    public void intersectLine(Line2D line) {
        this.line = line;
        this.points.clear();
        float rx0 = (float)this.rectangle.getMinX();
        float ry0 = (float)this.rectangle.getMinY();
        float rx1 = (float)this.rectangle.getMaxX();
        float ry1 = (float)this.rectangle.getMaxY();
        float x1 = (float)line.getX1();
        float y1 = (float)line.getY1();
        float x2 = (float)line.getX2();
        float y2 = (float)line.getY2();
        float dy = y2 - y1;
        float dx = x2 - x1;
        if (dx != 0.0f) {
            float y;
            float m = dy / dx;
            float b = y1 - m * x1;
            float x = (ry0 - b) / m;
            if (rx0 <= x && x <= rx1) {
                this.points.add(new Point2D.Float(x, ry0));
            }
            if (rx0 <= (x = (ry1 - b) / m) && x <= rx1) {
                this.points.add(new Point2D.Float(x, ry1));
            }
            if (ry0 <= (y = m * rx0 + b) && y <= ry1) {
                this.points.add(new Point2D.Float(rx0, y));
            }
            if (ry0 <= (y = m * rx1 + b) && y <= ry1) {
                this.points.add(new Point2D.Float(rx1, y));
            }
        } else {
            float x = x1;
            if (rx0 <= x && x <= rx1) {
                this.points.add(new Point2D.Float(x, ry0));
            }
            if (rx0 <= (x = x2) && x <= rx1) {
                this.points.add(new Point2D.Float(x, ry1));
            }
        }
    }

    public Line2D getLine() {
        return this.line;
    }

    public Set<Point2D> getPoints() {
        return this.points;
    }

    public Rectangle getRectangle() {
        return this.rectangle;
    }

    public String toString() {
        return "Rectangle: " + this.rectangle + ", points:" + this.points;
    }

    public static void main(String[] args) {
        Rectangle rectangle = new Rectangle(0, 0, 10, 10);
        Line2D.Float line = new Line2D.Float(4.0f, 4.0f, 5.0f, 5.0f);
        System.err.println("" + new Intersector(rectangle, line));
        System.err.println("" + new Intersector(rectangle, new Line2D.Float(9.0f, 11.0f, 11.0f, 9.0f)));
        System.err.println("" + new Intersector(rectangle, new Line2D.Float(1.0f, 1.0f, 3.0f, 2.0f)));
        System.err.println("" + new Intersector(rectangle, new Line2D.Float(4.0f, 6.0f, 6.0f, 4.0f)));
    }
}

