/*
 * Decompiled with CFR 0.152.
 */
package gui.event;

import ghidra.util.Msg;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class MouseBinding {
    private static final Pattern BUTTON_PATTERN = Pattern.compile("button(\\d+)", 2);
    private static final String SHIFT = "Shift";
    private static final String CTRL = "Ctrl";
    private static final String ALT = "Alt";
    private static final String META = "Meta";
    private int modifiers = -1;
    private int button = -1;

    public MouseBinding(int button) {
        this(button, -1);
    }

    public MouseBinding(int button, int modifiers) {
        this.button = button;
        this.modifiers = InputEvent.getMaskForButton(button);
        if (modifiers > 0) {
            this.modifiers |= modifiers;
        }
    }

    public int getButton() {
        return this.button;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getDisplayText() {
        String modifiersText = InputEvent.getModifiersExText(this.modifiers);
        if (StringUtils.isBlank((CharSequence)modifiersText)) {
            return "Button" + this.button;
        }
        return modifiersText;
    }

    public static MouseBinding getMouseBinding(MouseEvent e) {
        return new MouseBinding(e.getButton(), e.getModifiersEx());
    }

    public static MouseBinding getMouseBinding(String mouseString) {
        int button = MouseBinding.getButton(mouseString);
        if (button == -1) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(mouseString, "- +");
        ArrayList<String> pieces = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (pieces.contains(token)) continue;
            pieces.add(token);
        }
        int modifiers = 0;
        Iterator iterator = pieces.iterator();
        while (iterator.hasNext()) {
            String piece = (String)iterator.next();
            if (StringUtils.indexOfIgnoreCase((CharSequence)piece, (CharSequence)SHIFT) != -1) {
                modifiers |= 0x40;
                iterator.remove();
                continue;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)piece, (CharSequence)CTRL) != -1) {
                modifiers |= 0x80;
                iterator.remove();
                continue;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)piece, (CharSequence)ALT) != -1) {
                modifiers |= 0x200;
                iterator.remove();
                continue;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)piece, (CharSequence)META) == -1) continue;
            modifiers |= 0x100;
            iterator.remove();
        }
        return new MouseBinding(button, modifiers);
    }

    private static int getButton(String mouseString) {
        Matcher buttonMatcher = BUTTON_PATTERN.matcher(mouseString);
        if (buttonMatcher.find()) {
            String numberString = buttonMatcher.group(1);
            try {
                int intValue = Integer.parseInt(numberString);
                if (intValue > 0) {
                    return intValue;
                }
            }
            catch (NumberFormatException e) {
                Msg.error(MouseBinding.class, (Object)"Unable to parse button number %s in text %s".formatted(numberString, mouseString));
            }
        }
        return -1;
    }

    public boolean isMatchingRelease(MouseEvent e) {
        int otherButton = e.getButton();
        if (this.button != otherButton) {
            return false;
        }
        int id = e.getID();
        return id == 502 || id == 500;
    }

    public String toString() {
        return this.getDisplayText();
    }

    public int hashCode() {
        return Objects.hash(this.button, this.modifiers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MouseBinding other = (MouseBinding)obj;
        if (this.button != other.button) {
            return false;
        }
        return this.modifiers == other.modifiers;
    }
}

