/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.modules;

import ghidra.app.plugin.core.debug.service.modules.PeekOpenedDomainObject;
import ghidra.app.plugin.core.debug.utils.ProgramURLUtils;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.debug.api.modules.MapEntry;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ProjectData;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.modules.TraceConflictedMappingException;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceStaticMapping;
import ghidra.trace.model.modules.TraceStaticMappingManager;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.util.MathUtilities;
import ghidra.util.Msg;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class DebuggerStaticMappingUtils
extends Enum<DebuggerStaticMappingUtils> {
    private static final /* synthetic */ DebuggerStaticMappingUtils[] $VALUES;

    public static DebuggerStaticMappingUtils[] values() {
        return (DebuggerStaticMappingUtils[])$VALUES.clone();
    }

    public static DebuggerStaticMappingUtils valueOf(String name) {
        return Enum.valueOf(DebuggerStaticMappingUtils.class, name);
    }

    protected static <T> T noProject(Object originator) {
        Msg.warn((Object)originator, (Object)"The given program does not exist in any project");
        return null;
    }

    protected static void collectLibraries(ProjectData project, DomainFile cur, Set<DomainFile> col) {
        if (!Program.class.isAssignableFrom(cur.getDomainObjectClass()) || !col.add(cur)) {
            return;
        }
        HashSet<String> paths = new HashSet<String>();
        try (PeekOpenedDomainObject peek = new PeekOpenedDomainObject(cur);){
            DomainObject domainObject = peek.object;
            if (!(domainObject instanceof Program)) {
                return;
            }
            Program program = (Program)domainObject;
            ExternalManager externalManager = program.getExternalManager();
            for (String libraryName : externalManager.getExternalLibraryNames()) {
                Library library = externalManager.getExternalLibrary(libraryName);
                String path = library.getAssociatedProgramPath();
                if (path == null) continue;
                paths.add(path);
            }
        }
        for (String libraryPath : paths) {
            DomainFile libFile = project.getFile(libraryPath);
            if (libFile == null) continue;
            DebuggerStaticMappingUtils.collectLibraries(project, libFile, col);
        }
    }

    public static Set<DomainFile> collectLibraries(Collection<DomainFile> seeds) {
        LinkedHashSet<DomainFile> result = new LinkedHashSet<DomainFile>();
        for (DomainFile seed : seeds) {
            DebuggerStaticMappingUtils.collectLibraries(seed.getParent().getProjectData(), seed, result);
        }
        return result;
    }

    public static void addMapping(TraceLocation from, ProgramLocation to, long length, boolean truncateExisting) throws TraceConflictedMappingException {
        Program tp = to.getProgram();
        if (tp instanceof TraceProgramView) {
            throw new IllegalArgumentException("Mapping destination cannot be a " + TraceProgramView.class.getSimpleName());
        }
        TraceStaticMappingManager manager = from.getTrace().getStaticMappingManager();
        URL toURL = ProgramURLUtils.getUrlFromProgram(tp);
        if (toURL == null) {
            DebuggerStaticMappingUtils.noProject(DebuggerStaticMappingUtils.class);
        }
        Address fromAddress = from.getAddress();
        Address toAddress = to.getByteAddress();
        long maxFromLengthMinus1 = fromAddress.getAddressSpace().getMaxAddress().subtract(fromAddress);
        long maxToLengthMinus1 = toAddress.getAddressSpace().getMaxAddress().subtract(toAddress);
        if (Long.compareUnsigned(length - 1L, maxFromLengthMinus1) > 0) {
            throw new IllegalArgumentException("Length would cause address overflow in trace");
        }
        if (Long.compareUnsigned(length - 1L, maxToLengthMinus1) > 0) {
            throw new IllegalArgumentException("Length would cause address overflow in program");
        }
        Address end = fromAddress.addWrap(length - 1L);
        AddressRangeImpl range = new AddressRangeImpl(fromAddress, end);
        Lifespan fromLifespan = from.getLifespan();
        if (truncateExisting) {
            long truncEnd = fromLifespan.lmin() - 1L;
            for (TraceStaticMapping existing : List.copyOf(manager.findAllOverlapping((AddressRange)range, fromLifespan))) {
                existing.delete();
                if (!fromLifespan.minIsFinite() || Lifespan.DOMAIN.compare(existing.getStartSnap(), truncEnd) > 0) continue;
                manager.add(existing.getTraceAddressRange(), Lifespan.span((long)existing.getStartSnap(), (long)truncEnd), existing.getStaticProgramURL(), existing.getStaticAddress());
            }
        }
        manager.add((AddressRange)range, fromLifespan, toURL, toAddress.toString(true));
    }

    public static void addMapping(MapEntry<?, ?> entry, boolean truncateExisting) throws TraceConflictedMappingException {
        TraceLocation fromLoc = entry.getFromTraceLocation();
        ProgramLocation toLoc = entry.getToProgramLocation();
        long length = entry.getMappingLength();
        DebuggerStaticMappingUtils.addMapping(fromLoc, toLoc, length, truncateExisting);
    }

    public static boolean isReal(MemoryBlock block) {
        return block.isLoaded() && !block.isOverlay() && !block.isExternalBlock();
    }

    public static void addIdentityMapping(Trace from, Program toProgram, Lifespan lifespan, boolean truncateExisting) throws TraceConflictedMappingException {
        AddressSet failures = new AddressSet();
        HashSet conflicts = new HashSet();
        HashMap<AddressSpace, Extrema> extremaBySpace = new HashMap<AddressSpace, Extrema>();
        for (MemoryBlock block : toProgram.getMemory().getBlocks()) {
            if (!DebuggerStaticMappingUtils.isReal(block)) continue;
            AddressRangeImpl range = new AddressRangeImpl(block.getStart(), block.getEnd());
            extremaBySpace.computeIfAbsent(range.getAddressSpace(), s -> new Extrema()).consider((AddressRange)range);
        }
        for (Extrema extrema : extremaBySpace.values()) {
            AddressRange fromRange = DebuggerStaticMappingUtils.clippedRange(from, extrema.getMin().getAddressSpace().getName(), extrema.getMin().getOffset(), extrema.getMax().getOffset());
            if (fromRange == null) continue;
            try {
                DebuggerStaticMappingUtils.addMapping((TraceLocation)new DefaultTraceLocation(from, null, lifespan, fromRange.getMinAddress()), new ProgramLocation(toProgram, extrema.getMin()), fromRange.getLength(), truncateExisting);
            }
            catch (TraceConflictedMappingException e) {
                failures.add(fromRange);
                conflicts.addAll(e.getConflicts());
                Msg.error(DebuggerStaticMappingUtils.class, (Object)("Could not add identity mapping " + String.valueOf(fromRange) + ": " + e.getMessage()));
            }
        }
        if (!failures.isEmpty()) {
            throw new TraceConflictedMappingException("Conflicting mappings for " + String.valueOf(failures), conflicts);
        }
    }

    protected static AddressRange clippedRange(Trace trace, String spaceName, long min, long max) {
        AddressSpace space = trace.getBaseAddressFactory().getAddressSpace(spaceName);
        if (space == null) {
            return null;
        }
        Address spaceMax = space.getMaxAddress();
        if (Long.compareUnsigned(min, spaceMax.getOffset()) > 0) {
            return null;
        }
        if (Long.compareUnsigned(max, spaceMax.getOffset()) > 0) {
            return new AddressRangeImpl(space.getAddress(min), spaceMax);
        }
        return new AddressRangeImpl(space.getAddress(min), space.getAddress(max));
    }

    public static String getImageName(URL staticProgramURL) {
        String[] parts = staticProgramURL.toExternalForm().split("/");
        return parts[parts.length - 1];
    }

    public static String computeMappedFiles(Trace trace, long snap, AddressRange range) {
        List mappings = List.copyOf(trace.getStaticMappingManager().findAllOverlapping(range, Lifespan.at((long)snap)));
        if (mappings.isEmpty()) {
            return "";
        }
        if (mappings.size() == 1) {
            TraceStaticMapping single = (TraceStaticMapping)mappings.get(0);
            AddressRange mappedRange = single.getTraceAddressRange();
            if (mappedRange.contains(range.getMinAddress()) && mappedRange.contains(range.getMaxAddress())) {
                return DebuggerStaticMappingUtils.getImageName(single.getStaticProgramURL());
            }
            return DebuggerStaticMappingUtils.getImageName(single.getStaticProgramURL()) + "*";
        }
        List<String> names = mappings.stream().map(m -> DebuggerStaticMappingUtils.getImageName(m.getStaticProgramURL())).sorted().distinct().toList();
        if (names.size() == 1) {
            return names.get(0) + "*";
        }
        return names.stream().collect(Collectors.joining(","));
    }

    public static Function getFunction(Address pc, DebuggerCoordinates coordinates, ServiceProvider serviceProvider) {
        return DebuggerStaticMappingUtils.getFunction(pc, coordinates.getTrace(), coordinates.getSnap(), serviceProvider);
    }

    public static Function getFunction(Address pc, Trace trace, long snap, ServiceProvider serviceProvider) {
        if (pc == null) {
            return null;
        }
        DebuggerStaticMappingService mappingService = (DebuggerStaticMappingService)serviceProvider.getService(DebuggerStaticMappingService.class);
        if (mappingService == null) {
            return null;
        }
        DefaultTraceLocation dloc = new DefaultTraceLocation(trace, null, Lifespan.at((long)snap), pc);
        ProgramLocation sloc = mappingService.getOpenMappedLocation((TraceLocation)dloc);
        if (sloc == null) {
            return null;
        }
        return sloc.getProgram().getFunctionManager().getFunctionContaining(sloc.getAddress());
    }

    public static String computeModuleShortName(String path) {
        int sep = path.lastIndexOf(92);
        if (sep > 0 && sep < path.length()) {
            path = path.substring(sep + 1);
        }
        if ((sep = path.lastIndexOf(47)) > 0 && sep < path.length()) {
            path = path.substring(sep + 1);
        }
        return path;
    }

    public static String getModuleName(Address pc, DebuggerCoordinates coordinates) {
        return DebuggerStaticMappingUtils.getModuleName(pc, coordinates.getTrace(), coordinates.getSnap());
    }

    public static String getModuleName(Address pc, Trace trace, long snap) {
        if (pc == null || trace == null) {
            return null;
        }
        Iterator iterator = trace.getModuleManager().getModulesAt(snap, pc).iterator();
        if (iterator.hasNext()) {
            TraceModule module = (TraceModule)iterator.next();
            return DebuggerStaticMappingUtils.computeModuleShortName(module.getName(snap));
        }
        return null;
    }

    private static /* synthetic */ DebuggerStaticMappingUtils[] $values() {
        return new DebuggerStaticMappingUtils[0];
    }

    static {
        $VALUES = DebuggerStaticMappingUtils.$values();
    }

    public static class Extrema {
        private Address min = null;
        private Address max = null;

        public void consider(Address min, Address max) {
            this.min = this.min == null ? min : (Address)MathUtilities.cmin((Comparable)this.min, (Comparable)min);
            this.max = this.max == null ? max : (Address)MathUtilities.cmax((Comparable)this.max, (Comparable)max);
        }

        public void consider(AddressRange range) {
            this.consider(range.getMinAddress(), range.getMaxAddress());
        }

        public void consider(Address address) {
            this.consider(address, address);
        }

        public Address getMin() {
            return this.min;
        }

        public Address getMax() {
            return this.max;
        }

        public long getLength() {
            return this.max.subtract(this.min) + 1L;
        }

        public AddressRange getRange() {
            return new AddressRangeImpl(this.getMin(), this.getMax());
        }
    }
}

