/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.cramfs;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.cramfs.CramFsBlockReader;
import ghidra.file.formats.cramfs.CramFsInode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LazyCramFsInputStream
extends InputStream {
    private CramFsBlockReader cramFsBlockReader;
    private InputStream currentDecompressedBlockInputStream = new ByteArrayInputStream(new byte[0]);
    private int currentCompressedBlockIndex;

    public LazyCramFsInputStream(ByteProvider provider, CramFsInode cramfsInode, boolean isLittleEndian) throws IOException {
        this.cramFsBlockReader = new CramFsBlockReader(provider, cramfsInode, isLittleEndian);
    }

    @Override
    public int read() throws IOException {
        int byteRead = this.currentDecompressedBlockInputStream.read();
        if (byteRead == -1 && this.currentCompressedBlockIndex < this.cramFsBlockReader.getNumBlockPointers()) {
            this.currentDecompressedBlockInputStream = this.cramFsBlockReader.readDataBlockDecompressed(this.currentCompressedBlockIndex);
            byteRead = this.currentDecompressedBlockInputStream.read();
            ++this.currentCompressedBlockIndex;
        }
        return byteRead;
    }
}

