/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.userdump;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Module
implements StructConverter {
    public static final String NAME = "MODULE_";
    private long moduleBase;
    private long moduleSize;
    private int moduleNameLength;
    private String moduleName;
    private DumpFileReader reader;
    private long index;

    Module(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setModuleBase(this.reader.readNextPointer());
        this.setModuleSize(this.reader.readNextUnsignedInt());
        this.setModuleNameLength(this.reader.readNextInt());
        this.setModuleName(this.reader.readNextAsciiString(this.getModuleNameLength()));
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME + Long.toHexString(this.moduleBase), 0);
        struct.add(StructConverter.POINTER, this.reader.getPointerSize(), "ModuleBase", null);
        struct.add(StructConverter.DWORD, 4, "ModuleSize", null);
        struct.add(StructConverter.DWORD, 4, "ModuleInfoLength", null);
        if (this.getModuleNameLength() > 0) {
            struct.add((DataType)new StringDataType(), this.getModuleNameLength(), "ModuleInfo", null);
        }
        struct.setCategoryPath(new CategoryPath("/UDMP"));
        return struct;
    }

    public long getModuleBase() {
        return this.moduleBase;
    }

    public void setModuleBase(long moduleBase) {
        this.moduleBase = moduleBase;
    }

    public long getModuleSize() {
        return this.moduleSize;
    }

    public void setModuleSize(long moduleSize) {
        this.moduleSize = moduleSize;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public int getModuleNameLength() {
        return this.moduleNameLength;
    }

    public void setModuleNameLength(int moduleNameLength) {
        this.moduleNameLength = moduleNameLength;
    }
}

