/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.applesingle;

import java.io.PrintStream;
import org.catacombae.hfsexplorer.fs.AppleSingleBuilder;
import org.catacombae.util.Util;

public class AppleSingleHeader {
    public static final int STRUCTSIZE = 26;
    private static final long MAX_UINT = 0xFFFFFFFFL;
    private static final int MAX_USHORT = 65535;
    private final byte[] magicNumber = new byte[4];
    private final byte[] versionNumber = new byte[4];
    private final byte[] homeFileSystem = new byte[16];
    private final byte[] numEntries = new byte[2];

    public AppleSingleHeader(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.magicNumber, 0, 4);
        System.arraycopy(data, offset + 4, this.versionNumber, 0, 4);
        System.arraycopy(data, offset + 8, this.homeFileSystem, 0, 16);
        System.arraycopy(data, offset + 24, this.numEntries, 0, 2);
    }

    public AppleSingleHeader(long magicNumber, long versionNumber, AppleSingleBuilder.FileSystem homeFileSystem, int numEntries) {
        if (magicNumber < 0L || magicNumber > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Illegal value for magicNumber (" + magicNumber + ")");
        }
        if (versionNumber < 0L || versionNumber > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Illegal value for versionNumber (" + versionNumber + ")");
        }
        if (homeFileSystem == null) {
            throw new IllegalArgumentException("homeFileSystem == null");
        }
        if (numEntries < 0 || numEntries > 65535) {
            throw new IllegalArgumentException("Illegal value for numEntries (" + numEntries + ")");
        }
        System.arraycopy(Util.toByteArrayBE((int)magicNumber), 0, this.magicNumber, 0, 4);
        System.arraycopy(Util.toByteArrayBE((int)versionNumber), 0, this.versionNumber, 0, 4);
        System.arraycopy(homeFileSystem.getIdentifier(), 0, this.homeFileSystem, 0, 16);
        System.arraycopy(Util.toByteArrayBE((short)numEntries), 0, this.numEntries, 0, 2);
    }

    public static int length() {
        return 26;
    }

    public int getMagicNumber() {
        return Util.readIntBE(this.magicNumber);
    }

    public int getVersionNumber() {
        return Util.readIntBE(this.versionNumber);
    }

    public byte[] getHomeFileSystem() {
        return Util.readByteArrayBE(this.homeFileSystem);
    }

    public short getNumEntries() {
        return Util.readShortBE(this.numEntries);
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " magicNumber: " + this.getMagicNumber());
        ps.println(prefix + " versionNumber: 0x" + Util.toHexStringBE(this.getVersionNumber()));
        ps.println(prefix + " homeFileSystem: \"" + Util.readString(this.getHomeFileSystem(), "MacRoman") + "\"");
        ps.println(prefix + " numEntries: " + this.getNumEntries());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "AppleSingleHeader:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[26];
        int offset = 0;
        System.arraycopy(this.magicNumber, 0, result, offset, this.magicNumber.length);
        System.arraycopy(this.versionNumber, 0, result, offset += this.magicNumber.length, this.versionNumber.length);
        System.arraycopy(this.homeFileSystem, 0, result, offset += this.versionNumber.length, this.homeFileSystem.length);
        System.arraycopy(this.numEntries, 0, result, offset += this.homeFileSystem.length, this.numEntries.length);
        offset += this.numEntries.length;
        return result;
    }
}

