/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.RenderUnicodeSettingsDefinition;
import ghidra.util.StringUtilities;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class StringRenderBuilder {
    public static final char DOUBLE_QUOTE = '\"';
    public static final char SINGLE_QUOTE = '\'';
    private static final int MAX_ASCII = 128;
    private final StringBuilder sb = new StringBuilder();
    private final Charset cs;
    private final int charSize;
    private final boolean utfCharset;
    private final char quoteChar;
    private boolean byteMode = true;

    public StringRenderBuilder(Charset cs, int charSize) {
        this(cs, charSize, '\"');
    }

    public StringRenderBuilder(Charset cs, int charSize, char quoteChar) {
        this.cs = cs;
        this.charSize = charSize;
        this.quoteChar = quoteChar;
        this.utfCharset = cs.name().startsWith("UTF");
    }

    public void addEscapedCodePoint(int codePoint) {
        char escapeChar;
        this.ensureTextMode();
        char c = codePoint < 128 ? (char)'x' : (escapeChar = Character.isBmpCodePoint(codePoint) ? (char)'u' : 'U');
        int cpDigits = codePoint < 128 ? 2 : (Character.isBmpCodePoint(codePoint) ? 4 : 8);
        String s = Integer.toHexString(codePoint).toUpperCase();
        this.sb.append("\\").append(escapeChar);
        this.sb.append(StringUtilities.pad((String)s, (char)'0', (int)cpDigits));
    }

    public void decodeBytesUsingCharset(ByteBuffer bb, RenderUnicodeSettingsDefinition.RENDER_ENUM renderSetting, boolean trimTrailingNulls) {
        if (!bb.hasRemaining()) {
            return;
        }
        CharsetDecoder codec = this.cs.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        CharBuffer cb = CharBuffer.allocate(Math.max(10, bb.remaining() + bb.remaining() / 2));
        while (bb.hasRemaining()) {
            CoderResult cr = codec.decode(bb, cb, true);
            if (!bb.hasRemaining() && trimTrailingNulls) {
                this.trimTrailingNulls(cb);
            }
            this.flushStringModeCharBuf(cb, renderSetting);
            if (cr.isError()) {
                this.addByteSeq(bb, cr.length());
                continue;
            }
            if (!cr.isUnderflow()) continue;
            this.addByteSeq(bb, bb.remaining());
        }
        CoderResult flushResult = codec.flush(cb);
        if (!flushResult.isUnderflow()) {
            // empty if block
        }
        this.flushStringModeCharBuf(cb, renderSetting);
    }

    private void addString(String str) {
        this.ensureTextMode();
        this.sb.append(str);
    }

    private void addCodePointChar(int codePoint) {
        this.ensureTextMode();
        if (codePoint == this.quoteChar) {
            this.sb.append("\\");
        }
        this.sb.appendCodePoint(codePoint);
    }

    private void addByteSeq(ByteBuffer bytes, int count) {
        for (int i = 0; i < count; ++i) {
            this.ensureByteMode();
            this.sb.append("%02Xh".formatted(bytes.get()));
        }
    }

    private void addByteSeq(int codePoint) {
        CharBuffer cb = CharBuffer.wrap(new String(new int[]{codePoint}, 0, 1));
        ByteBuffer bb = this.cs.encode(cb);
        this.addByteSeq(bb, bb.limit());
    }

    private void trimTrailingNulls(CharBuffer cb) {
        while (cb.position() > 0 && cb.get(cb.position() - 1) == '\u0000') {
            cb.position(cb.position() - 1);
        }
    }

    private void flushStringModeCharBuf(CharBuffer cb, RenderUnicodeSettingsDefinition.RENDER_ENUM renderSetting) {
        cb.flip();
        this.renderChars(cb, renderSetting);
        cb.clear();
    }

    private void renderChars(CharSequence stringValue, RenderUnicodeSettingsDefinition.RENDER_ENUM renderSetting) {
        int codePoint;
        int strLength = stringValue.length();
        block4: for (int i = 0; i < strLength; i += Character.charCount(codePoint)) {
            codePoint = Character.codePointAt(stringValue, i);
            if (StringUtilities.isControlCharacterOrBackslash((int)codePoint)) {
                this.addString(StringUtilities.convertCodePointToEscapeSequence((int)codePoint));
                continue;
            }
            if (codePoint == 0) {
                if (this.byteMode) {
                    this.addByteSeq(0);
                    continue;
                }
                this.addString("\\0");
                continue;
            }
            if (Character.isISOControl(codePoint) || !Character.isDefined(codePoint)) {
                this.addByteSeq(codePoint);
                continue;
            }
            if (StringUtilities.isDisplayable((int)codePoint)) {
                this.addCodePointChar(codePoint);
                continue;
            }
            if (codePoint == 65279) {
                this.addEscapedCodePoint(codePoint);
                continue;
            }
            switch (renderSetting) {
                default: {
                    this.addCodePointChar(codePoint);
                    continue block4;
                }
                case BYTE_SEQ: {
                    this.addByteSeq(codePoint);
                    continue block4;
                }
                case ESC_SEQ: {
                    this.addEscapedCodePoint(codePoint);
                }
            }
        }
    }

    private void ensureTextMode() {
        if (this.sb.length() == 0) {
            this.sb.append(this.quoteChar);
        } else if (this.byteMode) {
            this.sb.append(',');
            this.sb.append(this.quoteChar);
        }
        this.byteMode = false;
    }

    private void ensureByteMode() {
        if (!this.byteMode) {
            this.sb.append(this.quoteChar);
        }
        if (this.sb.length() > 0) {
            this.sb.append(',');
        }
        this.byteMode = true;
    }

    public String build() {
        String s = !this.sb.isEmpty() ? this.toString() : "%c%c".formatted(Character.valueOf(this.quoteChar), Character.valueOf(this.quoteChar));
        String prefix = "";
        if (this.utfCharset && !s.isEmpty() && s.charAt(0) == this.quoteChar) {
            prefix = switch (this.charSize) {
                case 1 -> "u8";
                case 2 -> "u";
                case 4 -> "U";
                default -> "";
            };
        }
        return prefix + s;
    }

    public String toString() {
        Object str = this.sb.toString();
        if (!this.byteMode) {
            str = (String)str + this.quoteChar;
        }
        return str;
    }
}

