/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.AbstractSignedIntegerDataType;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.UnsignedShortDataType;

public class ShortDataType
extends AbstractSignedIntegerDataType {
    public static final ShortDataType dataType = new ShortDataType();

    public ShortDataType() {
        this(null);
    }

    public ShortDataType(DataTypeManager dtm) {
        super("short", dtm);
    }

    @Override
    public int getLength() {
        return this.getDataOrganization().getShortSize();
    }

    @Override
    public boolean hasLanguageDependantLength() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Signed Short Integer (compiler-specific size)";
    }

    @Override
    public String getCDeclaration() {
        return "short";
    }

    @Override
    public UnsignedShortDataType getOppositeSignednessDataType() {
        return UnsignedShortDataType.dataType.clone(this.getDataTypeManager());
    }

    @Override
    public ShortDataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new ShortDataType(dtm);
    }

    @Override
    public String getCTypeDeclaration(DataOrganization dataOrganization) {
        return null;
    }
}

