/*
 * Decompiled with CFR 0.152.
 */
package db.buffers;

import db.buffers.BlockStream;
import db.buffers.BlockStreamHandle;
import db.buffers.InputBlockStream;
import db.buffers.LocalBufferFile;
import db.buffers.LocalManagedBufferFile;
import db.buffers.RemoteBufferFileHandle;
import db.buffers.RemoteBufferFileImpl;
import db.buffers.RemoteManagedBufferFileHandle;
import ghidra.server.remote.RepositoryHandleImpl;
import ghidra.server.stream.BlockStreamServer;
import ghidra.server.stream.RemoteInputBlockStreamHandle;
import java.io.IOException;
import java.rmi.RemoteException;

public class RemoteManagedBufferFileImpl
extends RemoteBufferFileImpl
implements RemoteManagedBufferFileHandle {
    private LocalManagedBufferFile managedBufferFile;

    public RemoteManagedBufferFileImpl(LocalManagedBufferFile managedBufferFile, RepositoryHandleImpl owner, String associatedFilePath) throws RemoteException {
        super((LocalBufferFile)managedBufferFile, owner, associatedFilePath);
        this.managedBufferFile = managedBufferFile;
    }

    public RemoteManagedBufferFileHandle getSaveFile() throws IOException {
        LocalManagedBufferFile sf = (LocalManagedBufferFile)this.managedBufferFile.getSaveFile();
        return sf != null ? new RemoteManagedBufferFileImpl(sf, this.owner, this.associatedFilePath) : null;
    }

    @Override
    public boolean delete() throws IOException {
        if (this.managedBufferFile.getVersion() == 1) {
            this.owner.getRepository().log(this.associatedFilePath, "aborting file creation", this.owner.getUserName());
        }
        return super.delete();
    }

    public void saveCompleted(boolean commit) throws IOException {
        if (!commit) {
            int version = this.managedBufferFile.getVersion();
            this.owner.getRepository().log(this.associatedFilePath, "aborting file version " + version + " creation", this.owner.getUserName());
        }
        this.managedBufferFile.saveCompleted(commit);
    }

    public boolean canSave() throws IOException {
        return this.managedBufferFile.canSave();
    }

    public void setVersionComment(String comment) throws IOException {
        this.managedBufferFile.setVersionComment(comment);
    }

    public RemoteBufferFileHandle getNextChangeDataFile(boolean getFirst) throws IOException {
        LocalBufferFile cf = (LocalBufferFile)this.managedBufferFile.getNextChangeDataFile(getFirst);
        return cf != null ? new RemoteBufferFileImpl(cf, this.owner, this.associatedFilePath) : null;
    }

    public RemoteBufferFileHandle getSaveChangeDataFile() throws IOException {
        LocalBufferFile cf = (LocalBufferFile)this.managedBufferFile.getSaveChangeDataFile();
        return cf != null ? new RemoteBufferFileImpl(cf, this.owner, this.associatedFilePath) : null;
    }

    public long getCheckinID() throws IOException {
        return this.managedBufferFile.getCheckinID();
    }

    public byte[] getForwardModMapData(int oldVersion) throws IOException {
        return this.managedBufferFile.getForwardModMapData(oldVersion);
    }

    public InputBlockStream getInputBlockStream(byte[] changeMapData) throws IOException {
        throw new IOException("use of InputBlockStreamHandle required");
    }

    public BlockStreamHandle<InputBlockStream> getInputBlockStreamHandle(byte[] changeMapData) throws IOException {
        InputBlockStream inputBlockStream;
        RemoteInputBlockStreamHandle streamHandle;
        BlockStreamServer blockStreamServer = BlockStreamServer.getBlockStreamServer();
        if (!blockStreamServer.registerBlockStream(streamHandle = new RemoteInputBlockStreamHandle(blockStreamServer, inputBlockStream = this.managedBufferFile.getInputBlockStream(changeMapData)), (BlockStream)inputBlockStream)) {
            throw new IOException("request failed: block stream server not running");
        }
        return streamHandle;
    }
}

