/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi.launcher;

import generic.jar.ResourceFile;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.AbstractTraceRmiLaunchOpinion;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.TraceRmiLauncherServicePlugin;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.UnixShellScriptTraceRmiLaunchOffer;
import ghidra.debug.api.tracermi.TraceRmiLaunchOffer;
import ghidra.framework.OperatingSystem;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UnixShellScriptTraceRmiLaunchOpinion
extends AbstractTraceRmiLaunchOpinion {
    @Override
    public Collection<TraceRmiLaunchOffer> getOffers(TraceRmiLauncherServicePlugin plugin, Program program) {
        if (OperatingSystem.CURRENT_OPERATING_SYSTEM != OperatingSystem.WINDOWS) {
            return this.getScriptPaths(plugin.getTool()).flatMap(rf -> Stream.of(rf.listFiles(crf -> crf.getName().endsWith(".sh")))).flatMap(sf -> this.createOffer(plugin, program, (ResourceFile)sf)).collect(Collectors.toList());
        }
        return List.of();
    }

    protected Stream<TraceRmiLaunchOffer> createOffer(TraceRmiLauncherServicePlugin plugin, Program program, ResourceFile scriptFile) {
        try {
            return Stream.of(UnixShellScriptTraceRmiLaunchOffer.create(plugin, program, scriptFile.getFile(false)));
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Could not offer " + String.valueOf(scriptFile) + ": " + e.getMessage()), (Throwable)e);
            return Stream.of(new TraceRmiLaunchOffer[0]);
        }
    }
}

