/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.exec.ComposedPcodeUseropLibrary;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcodeCPort.slghsymbol.UserOpSymbol;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.sleigh.grammar.Location;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.reflect.TypeUtils;

public interface PcodeUseropLibrary<T> {
    public static final PcodeUseropLibrary<?> NIL = new EmptyPcodeUseropLibrary();

    public static Type getOperandType(Class<?> cls) {
        Map args = TypeUtils.getTypeArguments(cls, PcodeUseropLibrary.class);
        if (args == null) {
            return null;
        }
        if (args.isEmpty()) {
            return Object.class;
        }
        return (Type)args.get(PcodeUseropLibrary.class.getTypeParameters()[0]);
    }

    public static <T> PcodeUseropLibrary<T> nil() {
        return NIL;
    }

    public Map<String, PcodeUseropDefinition<T>> getUserops();

    default public PcodeUseropLibrary<T> compose(PcodeUseropLibrary<T> lib) {
        if (lib == null) {
            return this;
        }
        return new ComposedPcodeUseropLibrary<T>(List.of(this, lib));
    }

    default public Map<Integer, UserOpSymbol> getSymbols(SleighLanguage language) {
        HashMap<Integer, UserOpSymbol> symbols = new HashMap<Integer, UserOpSymbol>();
        HashSet<String> allNames = new HashSet<String>();
        int langOpCount = language.getNumberOfUserDefinedOpNames();
        for (int i = 0; i < langOpCount; ++i) {
            String name = language.getUserDefinedOpName(i);
            allNames.add(name);
        }
        int nextOpNo = langOpCount;
        for (PcodeUseropDefinition<T> uop : new TreeMap<String, PcodeUseropDefinition<T>>(this.getUserops()).values()) {
            String opName = uop.getName();
            if (!allNames.add(opName)) continue;
            int opNo = nextOpNo++;
            Location loc = new Location(this.getClass().getName() + ":" + opName, 0);
            UserOpSymbol sym = new UserOpSymbol(loc, opName);
            sym.setIndex(opNo);
            symbols.put(opNo, sym);
        }
        return symbols;
    }

    public static interface PcodeUseropDefinition<T> {
        public String getName();

        public int getInputCount();

        public void execute(PcodeExecutor<T> var1, PcodeUseropLibrary<T> var2, Varnode var3, List<Varnode> var4);

        default public void execute(PcodeExecutor<T> executor, PcodeUseropLibrary<T> library, PcodeOp op) {
            this.execute(executor, library, op.getOutput(), Arrays.asList(op.getInputs()).subList(1, op.getNumInputs()));
        }

        public boolean isFunctional();

        public boolean hasSideEffects();

        public boolean modifiesContext();

        public boolean canInlinePcode();

        public Method getJavaMethod();

        public PcodeUseropLibrary<?> getDefiningLibrary();
    }

    public static final class EmptyPcodeUseropLibrary
    implements PcodeUseropLibrary<Object> {
        @Override
        public Map<String, PcodeUseropDefinition<Object>> getUserops() {
            return Map.of();
        }
    }
}

