/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.opbehavior;

import ghidra.pcode.opbehavior.UnaryOpBehavior;
import java.math.BigInteger;

public class OpBehaviorLzcount
extends UnaryOpBehavior {
    public OpBehaviorLzcount() {
        super(73);
    }

    @Override
    public long evaluateUnary(int sizeout, int sizein, long val) {
        long count = 0L;
        for (long mask = 1L << sizein * 8 - 1; mask != 0L && (mask & val) == 0L; mask >>>= 1) {
            ++count;
        }
        return count;
    }

    @Override
    public BigInteger evaluateUnary(int sizeout, int sizein, BigInteger unsignedIn1) {
        int bitcount = 0;
        for (sizein = sizein * 8 - 1; sizein >= 0 && !unsignedIn1.testBit(sizein); --sizein) {
            ++bitcount;
        }
        if (sizeout == 1) {
            bitcount &= 0xFF;
        } else if (sizeout == 2) {
            bitcount &= 0xFFFF;
        }
        return BigInteger.valueOf(bitcount);
    }
}

