/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.analysis;

import ghidra.pcode.emu.jit.analysis.JitOpVisitor;
import ghidra.pcode.emu.jit.op.JitBinOp;
import ghidra.pcode.emu.jit.op.JitBranchIndOp;
import ghidra.pcode.emu.jit.op.JitCBranchOp;
import ghidra.pcode.emu.jit.op.JitCallOtherDefOp;
import ghidra.pcode.emu.jit.op.JitCallOtherOp;
import ghidra.pcode.emu.jit.op.JitCatenateOp;
import ghidra.pcode.emu.jit.op.JitLoadOp;
import ghidra.pcode.emu.jit.op.JitPhiOp;
import ghidra.pcode.emu.jit.op.JitStoreOp;
import ghidra.pcode.emu.jit.op.JitSynthSubPieceOp;
import ghidra.pcode.emu.jit.op.JitUnOp;
import ghidra.pcode.emu.jit.var.JitOutVar;
import ghidra.pcode.emu.jit.var.JitVal;

public interface JitOpUpwardVisitor
extends JitOpVisitor {
    @Override
    default public void visitUnOp(JitUnOp op) {
        this.visitVal(op.u());
    }

    @Override
    default public void visitBinOp(JitBinOp op) {
        this.visitVal(op.l());
        this.visitVal(op.r());
    }

    @Override
    default public void visitStoreOp(JitStoreOp op) {
        this.visitVal(op.offset());
        this.visitVal(op.value());
    }

    @Override
    default public void visitLoadOp(JitLoadOp op) {
        this.visitVal(op.offset());
    }

    @Override
    default public void visitCallOtherOp(JitCallOtherOp otherOp) {
        for (JitVal v : otherOp.args()) {
            this.visitVal(v);
        }
    }

    @Override
    default public void visitCallOtherDefOp(JitCallOtherDefOp otherOp) {
        for (JitVal v : otherOp.args()) {
            this.visitVal(v);
        }
    }

    @Override
    default public void visitCatenateOp(JitCatenateOp op) {
        for (JitVal p : op.parts()) {
            this.visitVal(p);
        }
    }

    @Override
    default public void visitPhiOp(JitPhiOp op) {
        for (JitVal opt : op.options().values()) {
            this.visitVal(opt);
        }
    }

    @Override
    default public void visitSubPieceOp(JitSynthSubPieceOp op) {
        this.visitVal(op.v());
    }

    @Override
    default public void visitCBranchOp(JitCBranchOp op) {
        this.visitVal(op.cond());
    }

    @Override
    default public void visitBranchIndOp(JitBranchIndOp op) {
        this.visitVal(op.target());
    }

    @Override
    default public void visitOutVar(JitOutVar v) {
        this.visitOp(v.definition());
    }
}

