/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.squashfs;

import ghidra.file.formats.squashfs.SquashBasicFileInode;
import ghidra.file.formats.squashfs.SquashFragment;
import ghidra.file.formats.squashfs.SquashInode;

public class SquashedFile {
    private final String name;
    private final String filePath;
    private final SquashInode inode;
    private final SquashFragment fragment;
    private final long size;

    public SquashedFile(SquashInode fileInode, SquashFragment tailEndFragment) {
        this.name = fileInode.getDirectoryTableEntry().getFileName();
        this.filePath = fileInode.getDirectoryTableEntry().getPath();
        this.inode = fileInode;
        this.fragment = tailEndFragment;
        if (this.inode.isFile()) {
            SquashBasicFileInode castInode = (SquashBasicFileInode)this.inode;
            this.size = castInode.getFileSize();
        } else {
            this.size = -1L;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.filePath;
    }

    public SquashInode getInode() {
        return this.inode;
    }

    public long getUncompressedSize() {
        return this.size;
    }

    public boolean hasFragment() {
        return this.fragment != null;
    }

    public SquashFragment getFragment() {
        return this.fragment;
    }
}

