/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.fieldpanel.field.Field;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.TokenIterator;
import ghidra.app.decompiler.component.ClangTextField;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.HighlightToken;
import ghidra.app.decompiler.component.TokenHighlights;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.util.HelpLocation;
import java.util.List;

public class PreviousHighlightedTokenAction
extends AbstractDecompilerAction {
    public PreviousHighlightedTokenAction() {
        super("Previous Highlighted Token");
        this.setPopupMenuData(new MenuData(new String[]{"Previous Highlight"}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData("Ctrl comma"));
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "GoToMiddleMouseHighlight"));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        if (!context.hasRealFunction()) {
            return false;
        }
        DecompilerPanel panel = context.getDecompilerPanel();
        TokenHighlights highlights = panel.getMiddleMouseHighlights();
        if (highlights != null) {
            return highlights.size() > 1;
        }
        return false;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        DecompilerPanel panel = context.getDecompilerPanel();
        TokenHighlights highlights = panel.getMiddleMouseHighlights();
        ClangToken cursorToken = context.getTokenAtCursor();
        TokenIterator it = new TokenIterator(cursorToken, false);
        it.next();
        if (this.goToNexToken(panel, it, highlights)) {
            return;
        }
        ClangToken lastToken = this.getLastToken(panel);
        it = new TokenIterator(lastToken, false);
        this.goToNexToken(panel, it, highlights);
    }

    private ClangToken getLastToken(DecompilerPanel panel) {
        List<Field> fields = panel.getFields();
        int lastLine = fields.size();
        Field line = fields.get(lastLine - 1);
        ClangTextField tf = (ClangTextField)line;
        return tf.getLastToken();
    }

    private boolean goToNexToken(DecompilerPanel panel, TokenIterator it, TokenHighlights highlights) {
        while (it.hasNext()) {
            ClangToken nextToken = it.next();
            HighlightToken hlToken = highlights.get(nextToken);
            if (hlToken == null) continue;
            ClangToken token = hlToken.getToken();
            panel.goToToken(token);
            return true;
        }
        return false;
    }
}

