/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.CategoryRecord;
import ghidra.features.bsim.query.protocol.BSimQuery;
import ghidra.features.bsim.query.protocol.ResponseInfo;
import ghidra.util.xml.XmlUtilities;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class InstallCategoryRequest
extends BSimQuery<ResponseInfo> {
    public String type_name = "";
    public boolean isdatecolumn = false;
    public ResponseInfo installresponse;

    public InstallCategoryRequest() {
        super("installcategory");
    }

    @Override
    public void buildResponseTemplate() {
        if (this.response == null) {
            this.installresponse = new ResponseInfo();
            this.response = this.installresponse;
        }
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        if (!CategoryRecord.enforceTypeCharacters(this.type_name)) {
            throw new IOException("Bad characters in requested category type");
        }
        fwrite.append('<').append(this.name);
        if (this.isdatecolumn) {
            fwrite.append(" datecolumn=\"true\"");
        }
        fwrite.append('>');
        fwrite.append(this.type_name);
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        XmlElement el = parser.start(new String[]{this.name});
        this.isdatecolumn = XmlUtilities.parseBoolean((String)el.getAttribute("datecolumn"));
        this.type_name = parser.end().getText();
    }
}

