/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.algo;

import ghidra.graph.GDirectedGraph;
import ghidra.graph.GEdge;
import ghidra.graph.GraphAlgorithms;
import ghidra.graph.algo.GraphNavigator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class DepthFirstSorter<V, E extends GEdge<V>> {
    private GDirectedGraph<V, E> g;
    GraphNavigator<V, E> navigator;
    private LinkedHashSet<V> visited;

    public static <V, E extends GEdge<V>> List<V> postOrder(GDirectedGraph<V, E> g) {
        return DepthFirstSorter.postOrder(g, GraphNavigator.topDownNavigator());
    }

    public static <V, E extends GEdge<V>> List<V> postOrder(GDirectedGraph<V, E> g, GraphNavigator<V, E> navigator) {
        DepthFirstSorter<V, E> sorter = new DepthFirstSorter<V, E>(g, navigator);
        List<V> list = sorter.getVerticesPostOrder();
        sorter.dispose();
        return list;
    }

    public static <V, E extends GEdge<V>> List<V> preOrder(GDirectedGraph<V, E> g) {
        return DepthFirstSorter.preOrder(g, GraphNavigator.topDownNavigator());
    }

    public static <V, E extends GEdge<V>> List<V> preOrder(GDirectedGraph<V, E> g, GraphNavigator<V, E> navigator) {
        DepthFirstSorter<V, E> sorter = new DepthFirstSorter<V, E>(g, navigator);
        List<V> list = sorter.getVerticesPreOrder();
        sorter.dispose();
        return list;
    }

    private DepthFirstSorter(GDirectedGraph<V, E> g, GraphNavigator<V, E> navigator) {
        this.g = g;
        this.navigator = navigator;
        int vertexCount = g.getVertexCount();
        this.visited = new LinkedHashSet(vertexCount);
    }

    private List<V> getVerticesPostOrder() {
        Set<V> seeds = this.navigator.getSources(this.g);
        for (V v : seeds) {
            this.postOrderVisit(v);
        }
        for (V v : this.g.getVertices()) {
            if (this.visited.contains(v)) continue;
            this.postOrderVisit(v);
        }
        return new ArrayList<V>(this.visited);
    }

    private List<V> getVerticesPreOrder() {
        Set<V> seeds = GraphAlgorithms.getSources(this.g);
        for (V v : seeds) {
            this.preOrderVisit(v);
        }
        for (V v : this.g.getVertices()) {
            if (this.visited.contains(v)) continue;
            this.preOrderVisit(v);
        }
        return new ArrayList<V>(this.visited);
    }

    private void postOrderVisit(V v) {
        if (this.visited.contains(v)) {
            return;
        }
        this.visited.add(v);
        Collection<V> successors = this.navigator.getSuccessors(this.g, v);
        for (V child : successors) {
            this.postOrderVisit(child);
        }
        this.visited.remove(v);
        this.visited.add(v);
    }

    private void preOrderVisit(V v) {
        if (this.visited.contains(v)) {
            return;
        }
        this.visited.add(v);
        Collection<V> successors = this.navigator.getSuccessors(this.g, v);
        for (V child : successors) {
            this.preOrderVisit(child);
        }
    }

    private void dispose() {
        this.visited.clear();
    }
}

