/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.app.nav.Navigatable;
import ghidra.app.util.viewer.field.FieldMouseHandlerExtension;
import ghidra.app.util.viewer.field.ImageFactoryField;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.data.Playable;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import java.awt.event.MouseEvent;

public class ImageFactoryFieldMouseHandler
implements FieldMouseHandlerExtension {
    private static final Class<?>[] SUPPORTED_CLASSES = new Class[]{ImageFactoryField.class};

    @Override
    public boolean fieldElementClicked(Object clickedObject, Navigatable navigatable, ProgramLocation location, MouseEvent mouseEvent, ServiceProvider serviceProvider) {
        if (mouseEvent.getButton() != 1) {
            return false;
        }
        if (mouseEvent.getClickCount() == 1) {
            return this.handleSingleClick(mouseEvent, navigatable, location);
        }
        return false;
    }

    @Override
    public Class<?>[] getSupportedProgramLocations() {
        return SUPPORTED_CLASSES;
    }

    private boolean handleSingleClick(MouseEvent mouseEvent, Navigatable navigatable, ProgramLocation location) {
        Data data;
        Object value;
        Program program = navigatable.getProgram();
        Listing listing = program.getListing();
        CodeUnit codeUnit = listing.getCodeUnitContaining(location.getAddress());
        if (codeUnit instanceof Data && (value = (data = (Data)codeUnit).getValue()) instanceof Playable) {
            ((Playable)value).clicked(mouseEvent);
            return true;
        }
        return false;
    }
}

