/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.cmd.data.CreateDataCmd;
import ghidra.app.cmd.label.AddUniqueLabelCmd;
import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.pef.ContainerHeader;
import ghidra.app.util.bin.format.pef.ExportedSymbol;
import ghidra.app.util.bin.format.pef.ImportStateCache;
import ghidra.app.util.bin.format.pef.ImportedLibrary;
import ghidra.app.util.bin.format.pef.ImportedSymbol;
import ghidra.app.util.bin.format.pef.LoaderInfoHeader;
import ghidra.app.util.bin.format.pef.LoaderRelocationHeader;
import ghidra.app.util.bin.format.pef.PefException;
import ghidra.app.util.bin.format.pef.Relocation;
import ghidra.app.util.bin.format.pef.RelocationState;
import ghidra.app.util.bin.format.pef.SectionHeader;
import ghidra.app.util.bin.format.pef.SectionKind;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramWrapperLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PefLoader
extends AbstractProgramWrapperLoader {
    public static final String PEF_NAME = "Preferred Executable Format (PEF)";
    private static final long MIN_BYTE_LENGTH = 40L;

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (provider.length() < 40L) {
            return loadSpecs;
        }
        try {
            ContainerHeader header = new ContainerHeader(provider);
            List<QueryResult> results = QueryOpinionService.query(this.getName(), header.getArchitecture(), null);
            for (QueryResult result : results) {
                loadSpecs.add(new LoadSpec((Loader)this, header.getImageBase(), result));
            }
            if (loadSpecs.isEmpty()) {
                loadSpecs.add(new LoadSpec((Loader)this, header.getImageBase(), true));
            }
        }
        catch (PefException pefException) {
            // empty catch block
        }
        return loadSpecs;
    }

    @Override
    public void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program, TaskMonitor monitor, MessageLog log) throws IOException, CancelledException {
        FileBytes fileBytes = MemoryBlockUtils.createFileBytes(program, provider, monitor);
        ImportStateCache importState = null;
        try {
            ContainerHeader header = new ContainerHeader(provider);
            monitor.setMessage("Completing PEF header parsing...");
            monitor.setCancelEnabled(false);
            header.parse();
            monitor.setCancelEnabled(true);
            importState = new ImportStateCache(program, header);
            program.setExecutableFormat(this.getName());
            this.processSections(header, program, fileBytes, importState, log, monitor);
            this.processExports(header, program, importState, log, monitor);
            this.processImports(header, program, importState, log, monitor);
            this.processRelocations(header, program, importState, log, monitor);
            this.processTocSymbol(header, program, importState, log, monitor);
            this.processMainSymbol(header, program, importState, log, monitor);
            this.processInitSymbol(header, program, importState, log, monitor);
            this.processTermSymbol(header, program, importState, log, monitor);
        }
        catch (PefException e) {
            throw new IOException(e);
        }
        catch (AddressOverflowException e) {
            throw new IOException(e);
        }
        finally {
            if (importState != null) {
                importState.dispose();
            }
        }
    }

    private void processTocSymbol(ContainerHeader header, Program program, ImportStateCache importState, MessageLog log, TaskMonitor monitor) {
        SymbolTable symbolTable = program.getSymbolTable();
        List<SectionHeader> sections = header.getSections();
        if (sections.size() < 2) {
            return;
        }
        SectionHeader dataSection = sections.get(1);
        if (!dataSection.isWrite()) {
            return;
        }
        Address tocAddress = importState.getTocAddress();
        if (tocAddress == null) {
            MemoryBlock dataBlock = importState.getMemoryBlockForSection(dataSection);
            tocAddress = dataBlock.getStart();
        }
        try {
            symbolTable.createLabel(tocAddress, ".toc", SourceType.IMPORTED);
            CreateDataCmd cmd = new CreateDataCmd(tocAddress, (DataType)new PointerDataType());
            cmd.applyTo(program);
        }
        catch (Exception e) {
            log.appendException((Throwable)e);
        }
    }

    private void processMainSymbol(ContainerHeader header, Program program, ImportStateCache importState, MessageLog log, TaskMonitor monitor) {
        SymbolTable symbolTable = program.getSymbolTable();
        LoaderInfoHeader loader = header.getLoader();
        int mainSectionIndex = loader.getMainSection();
        if (mainSectionIndex != -1) {
            SectionHeader mainSection = header.getSections().get(mainSectionIndex);
            MemoryBlock mainBlock = importState.getMemoryBlockForSection(mainSection);
            Address mainAddress = mainBlock.getStart().add((long)loader.getMainOffset());
            try {
                symbolTable.createLabel(mainAddress, ".main", SourceType.IMPORTED);
            }
            catch (Exception e) {
                log.appendException((Throwable)e);
            }
            if (mainSection.getSectionKind() == SectionKind.PackedData || mainSection.getSectionKind() == SectionKind.UnpackedData || mainSection.getSectionKind() == SectionKind.ExecutableData) {
                CreateDataCmd cmd = new CreateDataCmd(mainAddress, (DataType)new PointerDataType());
                cmd.applyTo(program);
                Data data = program.getListing().getDefinedDataAt(mainAddress);
                if (data == null) {
                    log.appendMsg("Unable to create data at main data structure.");
                } else {
                    Address address = (Address)data.getValue();
                    if (program.getMemory().contains(address)) {
                        try {
                            symbolTable.createLabel(address, "entry", SourceType.IMPORTED);
                            symbolTable.createLabel(address, "main", SourceType.IMPORTED);
                        }
                        catch (Exception e) {
                            log.appendException((Throwable)e);
                        }
                        program.getSymbolTable().addExternalEntryPoint(address);
                    }
                }
            }
        }
    }

    private void processInitSymbol(ContainerHeader header, Program program, ImportStateCache importState, MessageLog log, TaskMonitor monitor) {
        SymbolTable symbolTable = program.getSymbolTable();
        LoaderInfoHeader loader = header.getLoader();
        int initSectionIndex = loader.getInitSection();
        if (initSectionIndex != -1) {
            SectionHeader initSection = header.getSections().get(initSectionIndex);
            MemoryBlock initBlock = importState.getMemoryBlockForSection(initSection);
            Address address = initBlock.getStart().add((long)loader.getInitOffset());
            try {
                symbolTable.createLabel(address, ".init", SourceType.IMPORTED);
                CreateDataCmd cmd = new CreateDataCmd(address, (DataType)new PointerDataType());
                cmd.applyTo(program);
            }
            catch (Exception e) {
                log.appendException((Throwable)e);
            }
        }
    }

    private void processTermSymbol(ContainerHeader header, Program program, ImportStateCache importState, MessageLog log, TaskMonitor monitor) {
        SymbolTable symbolTable = program.getSymbolTable();
        LoaderInfoHeader loader = header.getLoader();
        int termSectionIndex = loader.getTermSection();
        if (termSectionIndex != -1) {
            SectionHeader termSection = header.getSections().get(termSectionIndex);
            MemoryBlock termBlock = importState.getMemoryBlockForSection(termSection);
            Address address = termBlock.getStart().add((long)loader.getTermOffset());
            try {
                symbolTable.createLabel(address, ".term", SourceType.IMPORTED);
                CreateDataCmd cmd = new CreateDataCmd(address, (DataType)new PointerDataType());
                cmd.applyTo(program);
            }
            catch (Exception e) {
                log.appendException((Throwable)e);
            }
        }
    }

    private void processImports(ContainerHeader header, Program program, ImportStateCache importState, MessageLog log, TaskMonitor monitor) {
        LoaderInfoHeader loader = header.getLoader();
        List<ImportedLibrary> libraries = loader.getImportedLibraries();
        List<ImportedSymbol> symbols = loader.getImportedSymbols();
        int symbolIndex = 0;
        MemoryBlock importBlock = this.makeFakeImportBlock(program, symbols, log, monitor);
        if (importBlock == null) {
            return;
        }
        Address start = importBlock.getStart();
        for (ImportedLibrary library : libraries) {
            if (monitor.isCancelled()) {
                return;
            }
            String libraryName = SymbolUtilities.replaceInvalidChars((String)library.getName(), (boolean)true);
            int symbolCount = library.getImportedSymbolCount();
            int symbolStart = library.getFirstImportedSymbol();
            int totalSymbolCount = symbolStart + symbolCount;
            for (int i = symbolStart; i < totalSymbolCount; ++i) {
                if (monitor.isCancelled()) {
                    return;
                }
                if (symbolIndex % 100 == 0) {
                    monitor.setMessage("Processing import " + symbolIndex + " of " + symbols.size());
                }
                ++symbolIndex;
                String symbolName = SymbolUtilities.replaceInvalidChars((String)symbols.get(i).getName(), (boolean)true);
                boolean success = importState.createLibrarySymbol(library, symbolName, start);
                if (!success) {
                    log.appendMsg("Unable to create symbol.");
                }
                this.createPointer(program, start, log);
                program.getReferenceManager().removeAllReferencesFrom(start);
                this.addExternalReference(program, start, libraryName, symbolName, log);
                start = start.add(4L);
            }
        }
    }

    private void createPointer(Program program, Address start, MessageLog log) {
        try {
            program.getListing().createData(start, (DataType)new PointerDataType(), 4);
        }
        catch (Exception e) {
            log.appendMsg(e.getMessage());
        }
    }

    private void addExternalReference(Program program, Address start, String libraryName, String symbolName, MessageLog log) {
        try {
            program.getReferenceManager().addExternalReference(start, libraryName, symbolName, null, SourceType.IMPORTED, 0, RefType.DATA);
        }
        catch (Exception e) {
            log.appendMsg(e.getMessage());
        }
    }

    private MemoryBlock makeFakeImportBlock(Program program, List<ImportedSymbol> symbols, MessageLog log, TaskMonitor monitor) {
        int size = symbols.size() * 4;
        if (size == 0) {
            return null;
        }
        Address start = this.getImportSectionAddress(program);
        try {
            return program.getMemory().createInitializedBlock("IMPORTS", start, (long)size, (byte)0, monitor, false);
        }
        catch (Exception e) {
            log.appendException((Throwable)e);
            return null;
        }
    }

    private void processRelocations(ContainerHeader header, Program program, ImportStateCache importState, MessageLog log, TaskMonitor monitor) throws IOException {
        List<LoaderRelocationHeader> relocationHeaders = header.getLoader().getRelocations();
        for (LoaderRelocationHeader relocationHeader : relocationHeaders) {
            if (monitor.isCancelled()) {
                return;
            }
            RelocationState state = new RelocationState(header, relocationHeader, program, importState);
            List<Relocation> relocations = relocationHeader.getRelocations();
            int relocationIndex = 0;
            int numRepeats = 0;
            int jumpToIdx = -1;
            while (relocationIndex < relocations.size()) {
                if (monitor.isCancelled()) {
                    return;
                }
                if (relocationIndex % 100 == 0) {
                    monitor.setMessage("Processing relocation " + relocationIndex + " of " + relocations.size());
                }
                Relocation relocation = relocations.get(relocationIndex);
                relocation.apply(importState, state, header, program, log, monitor);
                if (relocation.getRepeatCount() != 0) {
                    if (++numRepeats < relocation.getRepeatCount()) {
                        int blocksBack;
                        if (jumpToIdx != -1) {
                            relocationIndex = jumpToIdx;
                            continue;
                        }
                        jumpToIdx = relocationIndex;
                        for (blocksBack = 0; blocksBack < relocation.getRepeatChunks(); blocksBack += relocations.get(--jumpToIdx).getSizeInBytes() / 2) {
                        }
                        if (blocksBack == relocation.getRepeatChunks()) continue;
                        throw new IOException("specified number of repeat chunks does not point to the start of a relocation command!");
                    }
                    numRepeats = 0;
                    jumpToIdx = -1;
                }
                ++relocationIndex;
            }
            state.dispose();
        }
    }

    private void processExports(ContainerHeader header, Program program, ImportStateCache importState, MessageLog log, TaskMonitor monitor) {
        monitor.setMessage("Processing exports...");
        List<SectionHeader> sections = header.getSections();
        LoaderInfoHeader loader = header.getLoader();
        List<ExportedSymbol> exportedSymbols = loader.getExportedSymbols();
        for (ExportedSymbol symbol : exportedSymbols) {
            SectionHeader section;
            MemoryBlock block;
            Address symbolAddr;
            AddUniqueLabelCmd cmd;
            if (monitor.isCancelled()) {
                return;
            }
            if (symbol.getSectionIndex() == -2 || symbol.getSectionIndex() == -3 || (cmd = new AddUniqueLabelCmd(symbolAddr = (block = importState.getMemoryBlockForSection(section = sections.get(symbol.getSectionIndex()))).getStart().add((long)symbol.getSymbolValue()), symbol.getName(), null, SourceType.IMPORTED)).applyTo(program)) continue;
            log.appendMsg(cmd.getStatusMsg());
        }
    }

    private void processSections(ContainerHeader header, Program program, FileBytes fileBytes, ImportStateCache importState, MessageLog log, TaskMonitor monitor) throws AddressOverflowException, IOException {
        List<SectionHeader> sections = header.getSections();
        for (SectionHeader section : sections) {
            if (monitor.isCancelled()) {
                return;
            }
            Address start = this.getSectionAddressAligned(section, program);
            monitor.setMessage("Creating section at 0x" + String.valueOf(start) + "...");
            if (!section.getSectionKind().isInstantiated()) continue;
            if (section.getSectionKind() == SectionKind.PackedData) {
                byte[] unpackedData = section.getUnpackedData(monitor);
                ByteArrayInputStream is = new ByteArrayInputStream(unpackedData);
                MemoryBlockUtils.createInitializedBlock(program, false, section.getName(), start, is, (long)unpackedData.length, section.getSectionKind().toString(), null, section.isRead(), section.isWrite(), section.isExecute(), log, monitor);
            } else {
                MemoryBlockUtils.createInitializedBlock(program, false, section.getName(), start, fileBytes, (long)section.getContainerOffset(), section.getUnpackedLength(), section.getSectionKind().toString(), null, section.isRead(), section.isWrite(), section.isExecute(), log);
            }
            importState.setMemoryBlockForSection(section, program.getMemory().getBlock(start));
            if (section.getUnpackedLength() >= section.getTotalLength()) continue;
            start = start.add((long)section.getUnpackedLength());
            MemoryBlockUtils.createUninitializedBlock(program, false, section.getName(), start, section.getTotalLength() - section.getUnpackedLength(), section.getSectionKind().toString(), null, section.isRead(), section.isWrite(), section.isExecute(), log);
        }
    }

    private Address getSectionAddressAligned(SectionHeader section, Program program) {
        AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
        if (section.getDefaultAddress() != 0) {
            return space.getAddress((long)section.getDefaultAddress() & 0xFFFFFFFFL);
        }
        MemoryBlock[] blocks = program.getMemory().getBlocks();
        if (blocks.length == 0) {
            return space.getAddress(0x10000000L);
        }
        int last = blocks.length - 1;
        long address = blocks[last].getEnd().getOffset();
        long alignment = (long)Math.pow(2.0, section.getAlignment());
        long remainder = address % alignment;
        return space.getAddress(address + (alignment - remainder));
    }

    private Address getImportSectionAddress(Program program) {
        AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
        Address start = program.getMaxAddress();
        if (start == null) {
            return space.getAddress(0L);
        }
        long offset = start.getOffset();
        long alignment = offset % 16L;
        if (alignment != 0L) {
            alignment = 16L - alignment;
        }
        return space.getAddress(offset + alignment);
    }

    @Override
    public String getName() {
        return PEF_NAME;
    }
}

