/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.app.util.bin.format.swift.types.FieldDescriptor;
import ghidra.app.util.bin.format.swift.types.TargetContextDescriptor;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.Map;

public class TargetTypeContextDescriptor
extends TargetContextDescriptor {
    private String name;
    private int accessFunctionPtr;
    private int fields;

    public TargetTypeContextDescriptor(BinaryReader reader) throws IOException {
        super(reader);
        this.name = reader.readNext(SwiftUtils::relativeString);
        this.accessFunctionPtr = reader.readNextInt();
        this.fields = reader.readNextInt();
    }

    public String getName() {
        return this.name;
    }

    public int getAccessFunctionPtr() {
        return this.accessFunctionPtr;
    }

    public int getFields() {
        return this.fields;
    }

    public FieldDescriptor getFieldDescriptor(Map<Long, FieldDescriptor> fieldDescriptors) {
        FieldDescriptor fieldDescriptor = fieldDescriptors.get(this.getBase() + 8L + 8L + (long)this.fields);
        return fieldDescriptor != null ? fieldDescriptor : null;
    }

    @Override
    public String getStructureName() {
        return this.getMyStructureName();
    }

    @Override
    public String getDescription() {
        return "type context descriptor";
    }

    public String toString() {
        return this.name;
    }

    private final String getMyStructureName() {
        return TargetTypeContextDescriptor.class.getSimpleName();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getMyStructureName(), 0);
        struct.add(super.toDataType(), super.getStructureName(), "");
        struct.add((DataType)SwiftUtils.PTR_STRING, "Name", "The name of the type");
        struct.add((DataType)SwiftUtils.PTR_RELATIVE, "AccessFunctionPtr", "A pointer to the metadata access function for this type");
        struct.add((DataType)SwiftUtils.PTR_RELATIVE, "Fields", "A pointer to the field descriptor for the type, if any");
        struct.setCategoryPath(new CategoryPath("/SwiftTypeMetadata"));
        return struct;
    }
}

