/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.ByteProvider;
import java.io.IOException;
import java.io.InputStream;

public class ByteProviderInputStream
extends InputStream {
    protected ByteProvider provider;
    private long currentPosition;
    private long markPosition;

    public ByteProviderInputStream(ByteProvider provider) {
        this(provider, 0L);
    }

    public ByteProviderInputStream(ByteProvider provider, long startPosition) {
        this.provider = provider;
        this.markPosition = startPosition;
        this.currentPosition = startPosition;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min(this.provider.length() - this.currentPosition, Integer.MAX_VALUE);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.markPosition = this.currentPosition;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.currentPosition = this.markPosition;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long newPosition = Math.min(this.provider.length(), this.currentPosition + n);
        long skipped = newPosition - this.currentPosition;
        this.currentPosition = newPosition;
        return skipped;
    }

    @Override
    public int read() throws IOException {
        return this.currentPosition < this.provider.length() ? Byte.toUnsignedInt(this.provider.readByte(this.currentPosition++)) : -1;
    }

    @Override
    public int read(byte[] b, int bufferOffset, int len) throws IOException {
        long eof = this.provider.length();
        if (this.currentPosition >= eof) {
            return -1;
        }
        len = (int)Math.min((long)len, eof - this.currentPosition);
        byte[] bytes = this.provider.readBytes(this.currentPosition, len);
        System.arraycopy(bytes, 0, b, bufferOffset, len);
        this.currentPosition += (long)len;
        return len;
    }

    public static class ClosingInputStream
    extends ByteProviderInputStream {
        public ClosingInputStream(ByteProvider provider) {
            super(provider);
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.provider != null) {
                this.provider.close();
                this.provider = null;
            }
        }
    }
}

