/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.Array;
import ghidra.util.datastruct.BooleanArray;
import ghidra.util.datastruct.ByteArray;
import ghidra.util.datastruct.ByteArrayArray;
import ghidra.util.datastruct.DoubleArray;
import ghidra.util.datastruct.DoubleArrayArray;
import ghidra.util.datastruct.FloatArray;
import ghidra.util.datastruct.FloatArrayArray;
import ghidra.util.datastruct.IntArray;
import ghidra.util.datastruct.IntArrayArray;
import ghidra.util.datastruct.LongArray;
import ghidra.util.datastruct.LongArrayArray;
import ghidra.util.datastruct.ObjectArray;
import ghidra.util.datastruct.ShortArray;
import ghidra.util.datastruct.ShortArrayArray;
import ghidra.util.datastruct.StringArray;
import ghidra.util.datastruct.StringArrayArray;
import java.io.Serializable;

public class DataTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Array[] dataColumns = new Array[2];

    public void removeRow(int row) {
        for (int i = 0; i < this.dataColumns.length; ++i) {
            if (this.dataColumns[i] == null) continue;
            this.dataColumns[i].remove(row);
        }
    }

    public void copyRowTo(int row, DataTable table, int toRow) {
        for (int i = 0; i < this.dataColumns.length; ++i) {
            if (this.dataColumns[i] == null) continue;
            this.dataColumns[i].copyDataTo(row, table, toRow, i);
        }
    }

    public void putBoolean(int row, int col, boolean value) {
        if (col >= this.dataColumns.length) {
            this.growTable(col + 1);
        }
        BooleanArray ba = null;
        if (this.dataColumns[col] == null) {
            ba = new BooleanArray();
            this.dataColumns[col] = ba;
        } else {
            ba = (BooleanArray)this.dataColumns[col];
        }
        ba.put(row, value);
    }

    public boolean getBoolean(int row, int col) {
        BooleanArray ba = (BooleanArray)this.dataColumns[col];
        return ba.get(row);
    }

    public void putByte(int row, int col, byte value) {
        if (col >= this.dataColumns.length) {
            this.growTable(col + 1);
        }
        ByteArray ba = null;
        if (this.dataColumns[col] == null) {
            ba = new ByteArray();
            this.dataColumns[col] = ba;
        } else {
            ba = (ByteArray)this.dataColumns[col];
        }
        ba.put(row, value);
    }

    public byte getByte(int row, int col) {
        ByteArray ba = (ByteArray)this.dataColumns[col];
        return ba.get(row);
    }

    public void putShort(int row, int col, short value) {
        if (col >= this.dataColumns.length) {
            this.growTable(col + 1);
        }
        ShortArray sa = null;
        if (this.dataColumns[col] == null) {
            sa = new ShortArray();
            this.dataColumns[col] = sa;
        } else {
            sa = (ShortArray)this.dataColumns[col];
        }
        sa.put(row, value);
    }

    public short getShort(int row, int col) {
        ShortArray ba = (ShortArray)this.dataColumns[col];
        return ba.get(row);
    }

    public void putInt(int row, int col, int value) {
        if (col >= this.dataColumns.length) {
            this.growTable(col + 1);
        }
        IntArray ia = null;
        if (this.dataColumns[col] == null) {
            ia = new IntArray();
            this.dataColumns[col] = ia;
        } else {
            ia = (IntArray)this.dataColumns[col];
        }
        ia.put(row, value);
    }

    public int getInt(int row, int col) {
        IntArray ia = (IntArray)this.dataColumns[col];
        return ia.get(row);
    }

    public void putLong(int row, int col, long value) {
        if (col >= this.dataColumns.length) {
            this.growTable(col + 1);
        }
        LongArray la = null;
        if (this.dataColumns[col] == null) {
            la = new LongArray();
            this.dataColumns[col] = la;
        } else {
            la = (LongArray)this.dataColumns[col];
        }
        la.put(row, value);
    }

    public void putDouble(int row, int col, double value) {
        if (col >= this.dataColumns.length) {
            this.growTable(col + 1);
        }
        DoubleArray da = null;
        if (this.dataColumns[col] == null) {
            da = new DoubleArray();
            this.dataColumns[col] = da;
        } else {
            da = (DoubleArray)this.dataColumns[col];
        }
        da.put(row, value);
    }

    public void putFloat(int row, int col, float value) {
        if (col >= this.dataColumns.length) {
            this.growTable(col + 1);
        }
        FloatArray fa = null;
        if (this.dataColumns[col] == null) {
            fa = new FloatArray();
            this.dataColumns[col] = fa;
        } else {
            fa = (FloatArray)this.dataColumns[col];
        }
        fa.put(row, value);
    }

    public long getLong(int row, int col) {
        LongArray ba = (LongArray)this.dataColumns[col];
        return ba.get(row);
    }

    public float getFloat(int row, int col) {
        FloatArray fa = (FloatArray)this.dataColumns[col];
        return fa.get(row);
    }

    public double getDouble(int row, int col) {
        DoubleArray da = (DoubleArray)this.dataColumns[col];
        return da.get(row);
    }

    public void putString(int row, int col, String value) {
        if (col >= this.dataColumns.length) {
            this.growTable(col + 1);
        }
        StringArray sa = null;
        if (this.dataColumns[col] == null) {
            sa = new StringArray();
            this.dataColumns[col] = sa;
        } else {
            sa = (StringArray)this.dataColumns[col];
        }
        sa.put(row, value);
    }

    public void putObject(int row, int col, Object value) {
        if (col >= this.dataColumns.length) {
            this.growTable(col + 1);
        }
        ObjectArray oa = null;
        if (this.dataColumns[col] == null) {
            oa = new ObjectArray();
            this.dataColumns[col] = oa;
        } else {
            oa = (ObjectArray)this.dataColumns[col];
        }
        oa.put(row, value);
    }

    public String getString(int row, int col) {
        StringArray sa = (StringArray)this.dataColumns[col];
        return sa.get(row);
    }

    public Object getObject(int row, int col) {
        ObjectArray oa = (ObjectArray)this.dataColumns[col];
        return oa.get(row);
    }

    public void putByteArray(int row, int col, byte[] value) {
        if (col >= this.dataColumns.length) {
            this.growTable(col + 1);
        }
        ByteArrayArray baa = null;
        if (this.dataColumns[col] == null) {
            baa = new ByteArrayArray();
            this.dataColumns[col] = baa;
        } else {
            baa = (ByteArrayArray)this.dataColumns[col];
        }
        baa.put(row, value);
    }

    public byte[] getByteArray(int row, int col) {
        ByteArrayArray baa = (ByteArrayArray)this.dataColumns[col];
        return baa.get(row);
    }

    public void putShortArray(int row, int col, short[] value) {
        if (col >= this.dataColumns.length) {
            this.growTable(col + 1);
        }
        ShortArrayArray saa = null;
        if (this.dataColumns[col] == null) {
            saa = new ShortArrayArray();
            this.dataColumns[col] = saa;
        } else {
            saa = (ShortArrayArray)this.dataColumns[col];
        }
        saa.put(row, value);
    }

    public short[] getShortArray(int row, int col) {
        ShortArrayArray saa = (ShortArrayArray)this.dataColumns[col];
        return saa.get(row);
    }

    public void putIntArray(int row, int col, int[] value) {
        if (col >= this.dataColumns.length) {
            this.growTable(col + 1);
        }
        IntArrayArray iaa = null;
        if (this.dataColumns[col] == null) {
            iaa = new IntArrayArray();
            this.dataColumns[col] = iaa;
        } else {
            iaa = (IntArrayArray)this.dataColumns[col];
        }
        iaa.put(row, value);
    }

    public void putFloatArray(int row, int col, float[] value) {
        if (col >= this.dataColumns.length) {
            this.growTable(col + 1);
        }
        FloatArrayArray faa = null;
        if (this.dataColumns[col] == null) {
            faa = new FloatArrayArray();
            this.dataColumns[col] = faa;
        } else {
            faa = (FloatArrayArray)this.dataColumns[col];
        }
        faa.put(row, value);
    }

    public void putDoubleArray(int row, int col, double[] value) {
        if (col >= this.dataColumns.length) {
            this.growTable(col + 1);
        }
        DoubleArrayArray daa = null;
        if (this.dataColumns[col] == null) {
            daa = new DoubleArrayArray();
            this.dataColumns[col] = daa;
        } else {
            daa = (DoubleArrayArray)this.dataColumns[col];
        }
        daa.put(row, value);
    }

    public int[] getIntArray(int row, int col) {
        IntArrayArray iaa = (IntArrayArray)this.dataColumns[col];
        return iaa.get(row);
    }

    public void putLongArray(int row, int col, long[] value) {
        if (col >= this.dataColumns.length) {
            this.growTable(col + 1);
        }
        LongArrayArray laa = null;
        if (this.dataColumns[col] == null) {
            laa = new LongArrayArray();
            this.dataColumns[col] = laa;
        } else {
            laa = (LongArrayArray)this.dataColumns[col];
        }
        laa.put(row, value);
    }

    public long[] getLongArray(int row, int col) {
        LongArrayArray laa = (LongArrayArray)this.dataColumns[col];
        return laa.get(row);
    }

    public float[] getFloatArray(int row, int col) {
        FloatArrayArray faa = (FloatArrayArray)this.dataColumns[col];
        return faa.get(row);
    }

    public double[] getDoubleArray(int row, int col) {
        DoubleArrayArray daa = (DoubleArrayArray)this.dataColumns[col];
        return daa.get(row);
    }

    public void putStringArray(int row, int col, String[] value) {
        if (col >= this.dataColumns.length) {
            this.growTable(col + 1);
        }
        StringArrayArray saa = null;
        if (this.dataColumns[col] == null) {
            saa = new StringArrayArray();
            this.dataColumns[col] = saa;
        } else {
            saa = (StringArrayArray)this.dataColumns[col];
        }
        saa.put(row, value);
    }

    public String[] getStringArray(int row, int col) {
        StringArrayArray saa = (StringArrayArray)this.dataColumns[col];
        return saa.get(row);
    }

    private void growTable(int numCols) {
        Array[] newCols = new Array[numCols];
        System.arraycopy(this.dataColumns, 0, newCols, 0, this.dataColumns.length);
        this.dataColumns = newCols;
    }
}

