/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.app.cmd.label.SetLabelPrimaryCmd;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.AddressTranslator;
import ghidra.program.util.DiffUtility;
import ghidra.program.util.ProgramMerge;
import ghidra.program.util.SimpleDiffUtility;
import ghidra.program.util.SymbolMerge;
import ghidra.util.datastruct.LongLongHashtable;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;

public class FunctionMerge {
    private AddressTranslator originToResultTranslator;
    private Program fromProgram;
    private Program toProgram;
    private FunctionManager fromFunctionManager;
    private FunctionManager toFunctionManager;

    public FunctionMerge(AddressTranslator originToResultTranslator) {
        this.originToResultTranslator = originToResultTranslator;
        this.fromProgram = originToResultTranslator.getSourceProgram();
        this.toProgram = originToResultTranslator.getDestinationProgram();
        this.fromFunctionManager = this.fromProgram.getFunctionManager();
        this.toFunctionManager = this.toProgram.getFunctionManager();
    }

    static boolean isDefaultThunk(Function func) {
        return func.getSymbol().getSource() == SourceType.DEFAULT && func.isThunk();
    }

    Symbol replaceFunctionSymbol(Address originEntryPoint, LongLongHashtable conflictSymbolIDMap, TaskMonitor monitor) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        Address resultEntryPoint = this.originToResultTranslator.getAddress(originEntryPoint);
        Function fromFunction = this.fromFunctionManager.getFunctionAt(originEntryPoint);
        Function toFunction = this.toFunctionManager.getFunctionAt(resultEntryPoint);
        if (fromFunction != null && toFunction != null) {
            boolean sameNamespace;
            Symbol existingSymbol;
            String fromName = fromFunction.getName();
            Symbol fromSymbol = fromFunction.getSymbol();
            SourceType fromSource = fromSymbol.getSource();
            boolean isFromDefaultThunk = FunctionMerge.isDefaultThunk(fromFunction);
            String toName = toFunction.getName();
            Symbol toSymbol = toFunction.getSymbol();
            SourceType toSource = toSymbol.getSource();
            boolean isToDefaultThunk = FunctionMerge.isDefaultThunk(fromFunction);
            if (isFromDefaultThunk && isToDefaultThunk) {
                return toSymbol;
            }
            Namespace fromNamespace = isFromDefaultThunk ? this.fromProgram.getGlobalNamespace() : fromSymbol.getParentNamespace();
            Namespace expectedToNamespace = DiffUtility.getNamespace(fromNamespace, this.toProgram);
            if (!isFromDefaultThunk && expectedToNamespace != null && (existingSymbol = this.toProgram.getSymbolTable().getSymbol(fromName, originEntryPoint, expectedToNamespace)) != null) {
                SetLabelPrimaryCmd cmd;
                if (!existingSymbol.isPrimary() && (cmd = new SetLabelPrimaryCmd(originEntryPoint, fromName, expectedToNamespace)).applyTo(this.toProgram)) {
                    existingSymbol = cmd.getSymbol();
                }
                return existingSymbol;
            }
            Namespace currentToNamespace = isToDefaultThunk ? this.toProgram.getGlobalNamespace() : toSymbol.getParentNamespace();
            Symbol expectedNamespaceSymbol = SimpleDiffUtility.getSymbol((Symbol)fromNamespace.getSymbol(), (Program)this.toProgram);
            boolean bl = sameNamespace = currentToNamespace.getSymbol() == expectedNamespaceSymbol;
            if (fromSource == toSource && fromName.equals(toName) && sameNamespace) {
                return toSymbol;
            }
            Namespace desiredToNamespace = currentToNamespace;
            if (!sameNamespace) {
                desiredToNamespace = new SymbolMerge(this.fromProgram, this.toProgram).resolveNamespace(fromNamespace, conflictSymbolIDMap);
            }
            if (fromSource != toSource || !fromName.equals(toName) || currentToNamespace != desiredToNamespace) {
                toSymbol.setNameAndNamespace(fromName, desiredToNamespace, fromSource);
            }
            return toFunction.getSymbol();
        }
        return null;
    }

    static Symbol replaceFunctionSymbol(Program fromProgram, Program toProgram, Address entryPoint, LongLongHashtable conflictSymbolIDMap, TaskMonitor monitor) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        FunctionManager fromFunctionMgr = fromProgram.getFunctionManager();
        FunctionManager toFunctionMgr = toProgram.getFunctionManager();
        Function fromFunction = fromFunctionMgr.getFunctionAt(entryPoint);
        Function toFunction = toFunctionMgr.getFunctionAt(entryPoint);
        if (fromFunction != null && toFunction != null) {
            boolean sameNamespace;
            Symbol existingSymbol;
            String fromName = fromFunction.getName();
            Symbol fromSymbol = fromFunction.getSymbol();
            SourceType fromSource = fromSymbol.getSource();
            boolean isFromDefaultThunk = FunctionMerge.isDefaultThunk(fromFunction);
            String toName = toFunction.getName();
            Symbol toSymbol = toFunction.getSymbol();
            SourceType toSource = toSymbol.getSource();
            boolean isToDefaultThunk = FunctionMerge.isDefaultThunk(fromFunction);
            if (isFromDefaultThunk && isToDefaultThunk) {
                return toSymbol;
            }
            Namespace fromNamespace = isFromDefaultThunk ? fromProgram.getGlobalNamespace() : fromSymbol.getParentNamespace();
            Namespace expectedToNamespace = DiffUtility.getNamespace(fromNamespace, toProgram);
            if (!isFromDefaultThunk && expectedToNamespace != null && (existingSymbol = toProgram.getSymbolTable().getSymbol(fromName, entryPoint, expectedToNamespace)) != null) {
                SetLabelPrimaryCmd cmd;
                if (!existingSymbol.isPrimary() && (cmd = new SetLabelPrimaryCmd(entryPoint, fromName, expectedToNamespace)).applyTo(toProgram)) {
                    existingSymbol = cmd.getSymbol();
                }
                return existingSymbol;
            }
            Namespace currentToNamespace = isToDefaultThunk ? toProgram.getGlobalNamespace() : toSymbol.getParentNamespace();
            Symbol expectedNamespaceSymbol = SimpleDiffUtility.getSymbol((Symbol)fromNamespace.getSymbol(), (Program)toProgram);
            boolean bl = sameNamespace = currentToNamespace.getSymbol() == expectedNamespaceSymbol;
            if (fromSource == toSource && fromName.equals(toName) && sameNamespace) {
                return toSymbol;
            }
            Namespace desiredToNamespace = currentToNamespace;
            if (!sameNamespace) {
                desiredToNamespace = new SymbolMerge(fromProgram, toProgram).resolveNamespace(fromNamespace, conflictSymbolIDMap);
            }
            if (fromSource != toSource || !fromName.equals(toName) || currentToNamespace != desiredToNamespace) {
                toSymbol.setNameAndNamespace(fromName, desiredToNamespace, fromSource);
            }
            return toFunction.getSymbol();
        }
        return null;
    }

    public void replaceFunctionsNames(AddressSetView originAddressSet, TaskMonitor monitor) throws CancelledException {
        FunctionIterator originIter = this.fromFunctionManager.getFunctions(originAddressSet, true);
        LongLongHashtable conflictSymbolIDMap = new LongLongHashtable();
        monitor.setMessage("Replacing function names...");
        int max = (int)originAddressSet.getNumAddresses();
        monitor.initialize((long)max);
        int count = 0;
        while (originIter.hasNext()) {
            SourceType resultSource;
            monitor.setProgress((long)(++count));
            monitor.checkCancelled();
            Function originFunction = (Function)originIter.next();
            SourceType originSource = originFunction.getSymbol().getSource();
            Address originEntryPoint = originFunction.getEntryPoint();
            Address resultEntryPoint = this.originToResultTranslator.getAddress(originEntryPoint);
            monitor.setMessage("Replacing function name " + count + " of " + max);
            Function resultFunction = this.toFunctionManager.getFunctionAt(resultEntryPoint);
            if (resultFunction == null || (resultSource = resultFunction.getSymbol().getSource()) == SourceType.DEFAULT && originSource == SourceType.DEFAULT || resultFunction.getName().equals(originFunction.getName())) continue;
            try {
                this.replaceFunctionSymbol(originEntryPoint, conflictSymbolIDMap, monitor);
            }
            catch (DuplicateNameException duplicateNameException) {
            }
            catch (InvalidInputException invalidInputException) {
            }
            catch (CircularDependencyException circularDependencyException) {}
        }
        monitor.setProgress((long)max);
    }

    public static void replaceFunctionsNames(ProgramMerge pgmMerge, AddressSetView addressSet, TaskMonitor monitor) throws CancelledException {
        Program resultProgram = pgmMerge.getResultProgram();
        Program originProgram = pgmMerge.getOriginProgram();
        FunctionManager resultFM = resultProgram.getFunctionManager();
        FunctionManager originFM = originProgram.getFunctionManager();
        FunctionIterator iter = resultFM.getFunctions(addressSet, true);
        LongLongHashtable conflictSymbolIDMap = new LongLongHashtable();
        monitor.setMessage("Replacing function names...");
        long max = addressSet.getNumAddresses();
        monitor.initialize(max);
        int count = 0;
        while (iter.hasNext()) {
            monitor.setProgress((long)(++count));
            monitor.checkCancelled();
            Function resultFunction = (Function)iter.next();
            Address resultEntryPt = resultFunction.getEntryPoint();
            monitor.setMessage("Replacing function name " + count + " of " + max + ".  Address=" + resultEntryPt.toString(true));
            Function originFunction = originFM.getFunctionAt(resultEntryPt);
            if (originFunction == null || resultFunction.getName().equals(originFunction.getName())) continue;
            try {
                FunctionMerge.replaceFunctionSymbol(originProgram, resultProgram, resultEntryPt, conflictSymbolIDMap, monitor);
            }
            catch (DuplicateNameException duplicateNameException) {
            }
            catch (InvalidInputException invalidInputException) {
            }
            catch (CircularDependencyException circularDependencyException) {}
        }
        monitor.setProgress(max);
    }
}

