/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.resource;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ResourceDirectoryString
implements StructConverter {
    public static final String NAME = "IMAGE_RESOURCE_DIRECTORY_STRING";
    private short length;
    private String nameString;

    public ResourceDirectoryString(BinaryReader reader, int index) throws IOException {
        BinaryReader stringReader = reader.clone(index);
        this.length = stringReader.readNextShort();
        this.nameString = stringReader.readNextAsciiString(Short.toUnsignedInt(this.length));
    }

    public short getLength() {
        return this.length;
    }

    public String getNameString() {
        return this.nameString;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("IMAGE_RESOURCE_DIRECTORY_STRING_" + this.length, 0);
        struct.add(WORD, "Length", null);
        struct.add(STRING, (int)this.length, "NameString", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }

    public String toString() {
        return this.nameString;
    }
}

