/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree;

import docking.ComponentProvider;
import ghidra.app.context.ProgramSymbolActionContext;
import ghidra.app.plugin.core.symboltree.SymbolGTree;
import ghidra.app.plugin.core.symboltree.SymbolTreeProvider;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolTreeNode;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.TreePath;

public class SymbolTreeActionContext
extends ProgramSymbolActionContext {
    private TreePath[] selectionPaths;

    SymbolTreeActionContext(SymbolTreeProvider provider, Program program, SymbolGTree tree, TreePath[] selectionPaths) {
        super((ComponentProvider)provider, program, SymbolTreeActionContext.getSymbols(selectionPaths), (Component)((Object)tree));
        this.selectionPaths = selectionPaths;
    }

    public SymbolTreeProvider getSymbolTreeProvider() {
        return (SymbolTreeProvider)this.getComponentProvider();
    }

    public SymbolGTree getSymbolTree() {
        return (SymbolGTree)((Object)this.getContextObject());
    }

    public TreePath[] getSelectedSymbolTreePaths() {
        return this.selectionPaths;
    }

    public TreePath getSelectedPath() {
        if (this.selectionPaths.length == 1) {
            return this.selectionPaths[0];
        }
        return null;
    }

    public SymbolTreeNode getSelectedNode() {
        Object object;
        if (this.selectionPaths != null && this.selectionPaths.length == 1 && (object = this.selectionPaths[0].getLastPathComponent()) instanceof SymbolTreeNode) {
            SymbolTreeNode node = (SymbolTreeNode)((Object)object);
            return node;
        }
        return null;
    }

    public List<SymbolNode> getSelectedSymbolNodes() {
        if (this.selectionPaths == null) {
            return List.of();
        }
        ArrayList<SymbolNode> symbols = new ArrayList<SymbolNode>();
        for (TreePath treePath : this.selectionPaths) {
            Object object = treePath.getLastPathComponent();
            if (!(object instanceof SymbolNode)) continue;
            symbols.add((SymbolNode)((Object)object));
        }
        return symbols;
    }

    private static List<Symbol> getSymbols(TreePath[] selectionPaths) {
        if (selectionPaths == null) {
            return Collections.emptyList();
        }
        ArrayList<Symbol> symbols = new ArrayList<Symbol>();
        for (TreePath treePath : selectionPaths) {
            Object object = treePath.getLastPathComponent();
            if (!(object instanceof SymbolNode)) continue;
            SymbolNode symbolNode = (SymbolNode)((Object)object);
            symbols.add(symbolNode.getSymbol());
        }
        return symbols;
    }
}

