/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import ghidra.framework.cmd.BackgroundCommand;
import ghidra.program.database.symbol.EquateManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Enum;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.util.Msg;
import ghidra.util.UniversalID;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class CreateEnumEquateCommand
extends BackgroundCommand<Program> {
    private AddressSetView addresses;
    private Enum enoom;
    private Program program;
    private boolean shouldDoOnSubOps;
    private EquateTable equateTable;

    public CreateEnumEquateCommand(AddressSetView addresses, Enum enoom, boolean shouldDoOnSubOps) {
        this.addresses = Objects.requireNonNull(addresses);
        this.enoom = Objects.requireNonNull(enoom);
        this.shouldDoOnSubOps = shouldDoOnSubOps;
    }

    public String getName() {
        return "Create Enum Equate Command";
    }

    public boolean applyTo(Program p, TaskMonitor monitor) {
        this.program = p;
        monitor.setIndeterminate(true);
        monitor.setMessage("Installing Equate");
        this.equateTable = this.program.getEquateTable();
        try {
            this.applyEnum(monitor);
        }
        catch (CancelledException e) {
            return false;
        }
        return true;
    }

    private void applyEnum(TaskMonitor monitor) throws CancelledException {
        Listing listing = this.program.getListing();
        InstructionIterator it = listing.getInstructions(this.addresses, true);
        monitor.initialize(this.addresses.getNumAddresses());
        while (it.hasNext()) {
            monitor.checkCancelled();
            Instruction instruction = it.next();
            this.processsEquates(instruction);
            monitor.incrementProgress((long)instruction.getLength());
        }
    }

    private void processsEquates(Instruction instruction) {
        for (int opIndex = 0; opIndex < instruction.getNumOperands(); ++opIndex) {
            if (!this.shouldDoOnSubOps) {
                Scalar scalar = instruction.getScalar(opIndex);
                this.maybeCreateEquateOnScalar(instruction, opIndex, scalar);
                continue;
            }
            List subOperands = instruction.getDefaultOperandRepresentationList(opIndex);
            for (Object subOp : subOperands) {
                this.maybeCreateEquateOnScalar(instruction, opIndex, subOp);
            }
        }
    }

    private void maybeCreateEquateOnScalar(Instruction instruction, int opIndex, Object operandRepresentation) {
        if (!(operandRepresentation instanceof Scalar)) {
            return;
        }
        Scalar scalar = (Scalar)operandRepresentation;
        int enoomLength = this.enoom.getLength();
        boolean anyValuesMatch = Arrays.stream(this.enoom.getValues()).anyMatch(enumValue -> scalar.equals((Object)new Scalar(enoomLength * 8, enumValue, scalar.isSigned())));
        if (!anyValuesMatch) {
            return;
        }
        if (this.program.getDataTypeManager().findDataTypeForID(this.enoom.getUniversalID()) == null) {
            this.enoom = (Enum)this.program.getDataTypeManager().addDataType((DataType)this.enoom, null);
        }
        Address addr = instruction.getAddress();
        this.removeUnusedEquates(opIndex, scalar, addr);
        long value = scalar.getValue();
        String equateName = EquateManager.formatNameForEquate((UniversalID)this.enoom.getUniversalID(), (long)value);
        Equate equate = this.getOrCreateEquate(equateName, value);
        equate.addReference(addr, opIndex);
    }

    private void removeUnusedEquates(int opIndex, Scalar scalar, Address addr) {
        Equate existingEquate = this.equateTable.getEquate(addr, opIndex, scalar.getValue());
        if (existingEquate != null && existingEquate.getReferenceCount() <= 1) {
            this.equateTable.removeEquate(existingEquate.getName());
        }
    }

    private Equate getOrCreateEquate(String name, long value) {
        Equate equate = this.equateTable.getEquate(name);
        if (equate != null) {
            return equate;
        }
        try {
            equate = this.equateTable.createEquate(name, value);
        }
        catch (DuplicateNameException | InvalidInputException e) {
            Msg.error((Object)((Object)this), (Object)"Unexpected error creating equate", (Throwable)e);
        }
        return equate;
    }
}

