/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.refs;

import ghidra.framework.cmd.Command;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalManager;

public class RemoveExternalNameCmd
implements Command<Program> {
    private String externalName;
    private String status;

    public RemoveExternalNameCmd(String externalName) {
        this.externalName = externalName;
    }

    public boolean applyTo(Program program) {
        ExternalManager extMgr = program.getExternalManager();
        if (!extMgr.removeExternalLibrary(this.externalName)) {
            this.status = this.externalName + " can not be removed";
            return false;
        }
        return true;
    }

    public String getStatusMsg() {
        return this.status;
    }

    public String getName() {
        return "Remove External Program Name";
    }
}

