/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.DelimiterState;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFunctionListMsSymbol
extends AbstractMsSymbol {
    protected int count;
    protected List<RecordNumber> functionTypeList = new ArrayList<RecordNumber>();
    protected List<Integer> invocationCountsList = new ArrayList<Integer>();

    public AbstractFunctionListMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        int i;
        this.count = reader.parseInt();
        for (i = 0; i < this.count; ++i) {
            RecordNumber typeRecordNumber = RecordNumber.parseNoWitness(pdb, reader, RecordCategory.TYPE, 32);
            this.functionTypeList.add(typeRecordNumber);
        }
        for (i = 0; i < this.count; ++i) {
            if (reader.hasMore()) {
                this.invocationCountsList.add(reader.parseInt());
                continue;
            }
            this.invocationCountsList.add(0);
        }
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: Count: %d", this.getSymbolTypeName(), this.count));
        DelimiterState ds = new DelimiterState("", ", ");
        for (int i = 0; i < this.count; ++i) {
            if (i % 4 == 0) {
                builder.append("\n");
            }
            builder.append(ds.out(true, String.format("%s (%d, args) ", this.pdb.getTypeRecord(this.functionTypeList.get(i)), this.invocationCountsList.get(i))));
        }
    }
}

