/*
 * Decompiled with CFR 0.152.
 */
package generic.cache;

import generic.cache.BasicFactory;
import ghidra.util.timer.GTimer;
import ghidra.util.timer.GTimerMonitor;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;

public class CachingPool<T> {
    private static final long TIMEOUT = -1L;
    private boolean isDisposed;
    private BasicFactory<T> factory;
    private Deque<T> cache = new ArrayDeque<T>();
    private long disposeTimeout = -1L;
    private GTimerMonitor timerMonitor;

    public CachingPool(BasicFactory<T> factory) {
        this.factory = Objects.requireNonNull(factory);
    }

    public void setCleanupTimeout(long timeout) {
        this.disposeTimeout = timeout;
    }

    public synchronized T get() throws Exception {
        this.stopCleanupTimer();
        if (this.cache.isEmpty() || this.isDisposed) {
            return this.factory.create();
        }
        return this.cache.pop();
    }

    public synchronized void release(T t) {
        this.restartCleanupTimer();
        if (this.isDisposed) {
            this.factory.dispose(t);
            return;
        }
        this.cache.push(t);
    }

    public synchronized void dispose() {
        this.stopCleanupTimer();
        this.isDisposed = true;
        this.disposeCachedItems();
    }

    private synchronized void disposeCachedItems() {
        for (T t : this.cache) {
            this.factory.dispose(t);
        }
    }

    private void stopCleanupTimer() {
        if (this.timerMonitor != null) {
            this.timerMonitor.cancel();
        }
    }

    private void restartCleanupTimer() {
        if (this.timerMonitor != null) {
            this.timerMonitor.cancel();
        }
        this.timerMonitor = GTimer.scheduleRunnable(this.disposeTimeout, this::disposeCachedItems);
    }
}

