/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.target.path;

import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.path.PathFilter;
import ghidra.trace.model.target.path.PathMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;

public class PathPattern
implements PathFilter {
    private final KeyPath pattern;

    public PathPattern(KeyPath pattern) {
        this.pattern = pattern;
    }

    public String toString() {
        return String.format("<PathPattern %s>", this.pattern);
    }

    public String toPatternString() {
        return this.pattern.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PathPattern)) {
            return false;
        }
        PathPattern that = (PathPattern)obj;
        return Objects.equals(this.pattern, that.pattern);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    @Override
    public PathFilter or(PathFilter that) {
        if (this.equals(that)) {
            return this;
        }
        return PathMatcher.any(this, that);
    }

    public static boolean isWildcard(String pat) {
        return "[]".equals(pat) || "".equals(pat);
    }

    protected boolean matchesUpTo(KeyPath path, int length) {
        for (int i = 0; i < length; ++i) {
            if (PathFilter.keyMatches(this.pattern.key(i), path.key(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean matchesBackTo(KeyPath path, int length) {
        int patternMax = this.pattern.size() - 1;
        int pathMax = path.size() - 1;
        for (int i = 0; i < length; ++i) {
            if (PathFilter.keyMatches(this.pattern.key(patternMax - i), path.key(pathMax - i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(KeyPath path) {
        if (path.size() != this.pattern.size()) {
            return false;
        }
        return this.matchesUpTo(path, path.size());
    }

    @Override
    public boolean successorCouldMatch(KeyPath path, boolean strict) {
        if (path.size() > this.pattern.size()) {
            return false;
        }
        if (strict && path.size() == this.pattern.size()) {
            return false;
        }
        return this.matchesUpTo(path, path.size());
    }

    @Override
    public boolean ancestorMatches(KeyPath path, boolean strict) {
        if (path.size() < this.pattern.size()) {
            return false;
        }
        if (strict && path.size() == this.pattern.size()) {
            return false;
        }
        return this.matchesUpTo(path, this.pattern.size());
    }

    @Override
    public boolean ancestorCouldMatchRight(KeyPath path, boolean strict) {
        if (path.size() > this.pattern.size()) {
            return false;
        }
        if (strict && path.size() == this.pattern.size()) {
            return false;
        }
        return this.matchesBackTo(path, path.size());
    }

    @Override
    public KeyPath getSingletonPath() {
        if (this.pattern.containsWildcard()) {
            return null;
        }
        return this.pattern;
    }

    public KeyPath asPath() {
        return this.pattern;
    }

    public int countWildcards() {
        return this.pattern.countWildcards();
    }

    @Override
    public PathPattern getSingletonPattern() {
        return this;
    }

    @Override
    public Set<PathPattern> getPatterns() {
        return Set.of(this);
    }

    @Override
    public Set<String> getNextKeys(KeyPath path) {
        if (path.size() >= this.pattern.size()) {
            return Set.of();
        }
        if (!this.matchesUpTo(path, path.size())) {
            return Set.of();
        }
        return Set.of(this.pattern.key(path.size()));
    }

    @Override
    public Set<String> getNextNames(KeyPath path) {
        if (path.size() >= this.pattern.size()) {
            return Set.of();
        }
        if (!this.matchesUpTo(path, path.size())) {
            return Set.of();
        }
        String pat = this.pattern.key(path.size());
        if (KeyPath.isName(pat)) {
            return Set.of(pat);
        }
        return Set.of();
    }

    @Override
    public Set<String> getNextIndices(KeyPath path) {
        if (path.size() >= this.pattern.size()) {
            return Set.of();
        }
        if (!this.matchesUpTo(path, path.size())) {
            return Set.of();
        }
        String pat = this.pattern.key(path.size());
        if (KeyPath.isIndex(pat)) {
            return Set.of(KeyPath.parseIndex(pat));
        }
        return Set.of();
    }

    @Override
    public Set<String> getPrevKeys(KeyPath path) {
        if (path.size() >= this.pattern.size()) {
            return Set.of();
        }
        if (!this.matchesBackTo(path, path.size())) {
            return Set.of();
        }
        return Set.of(this.pattern.key(this.pattern.size() - 1 - path.size()));
    }

    @Override
    public boolean isNone() {
        return false;
    }

    @Override
    public PathPattern applyKeys(PathFilter.Align align, List<String> keys) {
        String[] result = new String[this.pattern.size()];
        ListIterator<String> kit = align.iterator(keys);
        ListIterator<String> pit = align.iterator(this.pattern.keys);
        while (pit.hasNext()) {
            int i = pit.nextIndex();
            String pat = pit.next();
            if (kit.hasNext() && PathPattern.isWildcard(pat)) {
                String index = kit.next();
                if (KeyPath.isIndex(pat)) {
                    result[i] = KeyPath.makeKey(index);
                    continue;
                }
                result[i] = index;
                continue;
            }
            result[i] = pat;
        }
        return new PathPattern(new KeyPath(result));
    }

    public List<String> matchKeys(KeyPath path, boolean matchLength) {
        int length = this.pattern.size();
        if (matchLength ? length != path.size() : length > path.size()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            String key;
            String pat = this.pattern.key(i);
            if (!PathFilter.keyMatches(pat, key = path.key(i))) {
                return null;
            }
            if (!PathPattern.isWildcard(pat)) continue;
            if (KeyPath.isIndex(pat)) {
                result.add(KeyPath.parseIndex(key));
                continue;
            }
            result.add(key);
        }
        return result;
    }

    void doRemoveRight(int count, Set<PathPattern> result) {
        KeyPath parent = this.pattern.parent(count);
        if (parent == null) {
            return;
        }
        result.add(new PathPattern(parent));
    }

    @Override
    public PathMatcher removeRight(int count) {
        HashSet<PathPattern> patterns = new HashSet<PathPattern>();
        this.doRemoveRight(count, patterns);
        return new PathMatcher(Collections.unmodifiableSet(patterns));
    }
}

