/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.database.listing.AbstractBaseDBTraceCodeUnitsMemoryView;
import ghidra.trace.database.listing.AbstractBaseDBTraceCodeUnitsView;
import ghidra.trace.database.listing.DBTraceCodeManager;
import ghidra.trace.database.listing.DBTraceCodeUnitAdapter;
import ghidra.trace.database.listing.UndefinedDBTraceData;
import ghidra.trace.model.TraceAddressSnapRange;
import java.util.Iterator;
import java.util.stream.StreamSupport;

public abstract class AbstractWithUndefinedDBTraceCodeUnitsMemoryView<T extends DBTraceCodeUnitAdapter, M extends AbstractBaseDBTraceCodeUnitsView<T>>
extends AbstractBaseDBTraceCodeUnitsMemoryView<T, M> {
    public AbstractWithUndefinedDBTraceCodeUnitsMemoryView(DBTraceCodeManager manager) {
        super(manager);
    }

    @Override
    protected T nullOrUndefined(long snap, Address address) {
        return (T)this.manager.doCreateUndefinedUnit(snap, address, null, 0);
    }

    @Override
    protected AddressSetView emptyOrFullAddressSetUndefined(AddressRange within) {
        return new AddressSet(within);
    }

    @Override
    protected boolean falseOrTrueUndefined() {
        return true;
    }

    @Override
    public Iterable<? extends T> emptyOrFullIterableUndefined(final long snap, final AddressRange range, final boolean forward) {
        return () -> new Iterator<T>(){
            Address address;
            {
                this.address = forward ? range.getMinAddress() : range.getMaxAddress();
            }

            @Override
            public boolean hasNext() {
                return this.address != null && (forward ? this.address.compareTo((Object)range.getMaxAddress()) <= 0 : this.address.compareTo((Object)range.getMinAddress()) >= 0);
            }

            @Override
            public T next() {
                UndefinedDBTraceData result = AbstractWithUndefinedDBTraceCodeUnitsMemoryView.this.manager.doCreateUndefinedUnit(snap, this.address, null, 0);
                this.address = forward ? this.address.next() : this.address.previous();
                return result;
            }
        };
    }

    @Override
    public Iterable<? extends T> emptyOrFullIterableUndefined(TraceAddressSnapRange tasr) {
        return () -> StreamSupport.stream(tasr.getLifespan().spliterator(), false).flatMap(snap -> StreamSupport.stream(this.emptyOrFullIterableUndefined((long)snap, tasr.getRange(), true).spliterator(), false).map(t -> t)).iterator();
    }
}

